/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.proto.HashType;
import com.google.crypto.tink.proto.HmacKeyFormat;
import com.google.crypto.tink.proto.HmacParams;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.OutputPrefixType;

public final class MacKeyTemplates {
    public static final KeyTemplate HMAC_SHA256_128BITTAG = MacKeyTemplates.createHmacKeyTemplate(32, 16, HashType.SHA256);
    public static final KeyTemplate HMAC_SHA256_256BITTAG = MacKeyTemplates.createHmacKeyTemplate(32, 32, HashType.SHA256);

    public static KeyTemplate createHmacKeyTemplate(int keySize, int tagSize, HashType hashType) {
        HmacParams params = HmacParams.newBuilder().setHash(hashType).setTagSize(tagSize).build();
        HmacKeyFormat format = HmacKeyFormat.newBuilder().setParams(params).setKeySize(keySize).build();
        return KeyTemplate.newBuilder().setValue(format.toByteString()).setTypeUrl("type.googleapis.com/google.crypto.tink.HmacKey").setOutputPrefixType(OutputPrefixType.TINK).build();
    }
}

