/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.awskms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.integration.awskms.AwsKmsAead;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;

public final class AwsKmsClient
implements KmsClient {
    public static final String PREFIX = "aws-kms://";
    private AWSKMS client;
    private String keyUri;

    public AwsKmsClient() {
    }

    public AwsKmsClient(String uri) {
        if (!uri.toLowerCase().startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with aws-kms://");
        }
        this.keyUri = uri;
    }

    @Override
    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase().startsWith(PREFIX);
    }

    @Override
    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        try {
            if (credentialPath == null) {
                return this.withDefaultCredentials();
            }
            return this.withCredentialsProvider((AWSCredentialsProvider)new PropertiesFileCredentialsProvider(credentialPath));
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    @Override
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        try {
            return this.withCredentialsProvider((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("cannot load default credentials", e);
        }
    }

    private KmsClient withCredentialsProvider(AWSCredentialsProvider provider) throws GeneralSecurityException {
        try {
            this.client = (AWSKMS)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials(provider)).build();
            return this;
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("cannot load credentials from provider", e);
        }
    }

    @Override
    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        return new AwsKmsAead(this.client, Validators.validateKmsKeyUriAndRemovePrefix(PREFIX, uri));
    }
}

