/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.test;

import com.connsec.client.oauth.builder.ServiceBuilder;
import com.connsec.client.oauth.builder.api.ConnsecApi20;
import com.connsec.client.oauth.model.OAuthRequest;
import com.connsec.client.oauth.model.Response;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.oauth.model.Verb;
import com.connsec.client.oauth.model.Verifier;
import com.connsec.client.oauth.oauth.OAuthService;
import java.util.Scanner;

public class Connsec20Example {
    private static final String NETWORK_NAME = "SinaWeibo";
    private static final String PROTECTED_RESOURCE_URL = "https://api.weibo.com/2/account/get_uid.json";
    private static final Token EMPTY_TOKEN = null;

    public static void main(String[] args) {
        String apiKey = "your_api_key";
        String apiSecret = "your_api_secret";
        OAuthService service = new ServiceBuilder().provider(ConnsecApi20.class).apiKey(apiKey).apiSecret(apiSecret).callback("http://www.dajie.com/oauth/sina").build();
        Scanner in = new Scanner(System.in);
        System.out.println("=== SinaWeibo's OAuth Workflow ===");
        System.out.println();
        System.out.println("Fetching the Authorization URL...");
        String authorizationUrl = service.getAuthorizationUrl(EMPTY_TOKEN);
        System.out.println("Got the Authorization URL!");
        System.out.println("Now go and authorize Scribe here:");
        System.out.println(authorizationUrl);
        System.out.println("And paste the authorization code here");
        System.out.print(">>");
        Verifier verifier = new Verifier(in.nextLine());
        System.out.println();
        System.out.println("Trading the Request Token for an Access Token...");
        Token accessToken = service.getAccessToken(EMPTY_TOKEN, verifier);
        System.out.println("Got the Access Token!");
        System.out.println("(if your curious it looks like this: " + accessToken + " )");
        System.out.println();
        System.out.println("Now we're going to access a protected resource...");
        OAuthRequest request = new OAuthRequest(Verb.GET, PROTECTED_RESOURCE_URL);
        service.signRequest(accessToken, request);
        Response response = request.send();
        System.out.println("Got it! Lets see what we found...");
        System.out.println();
        System.out.println(response.getCode());
        System.out.println(response.getBody());
        System.out.println();
        System.out.println("Thats it man! Go and build something awesome with Scribe! :)");
    }
}

