/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.oauth;

import com.connsec.client.oauth.builder.api.ConnsecApi20;
import com.connsec.client.oauth.builder.api.DefaultApi20;
import com.connsec.client.oauth.model.OAuthConfig;
import com.connsec.client.oauth.model.OAuthRequest;
import com.connsec.client.oauth.model.Response;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.oauth.model.Verb;
import com.connsec.client.oauth.model.Verifier;
import com.connsec.client.oauth.oauth.OAuthService;

public class OAuth20ServiceImpl
implements OAuthService {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;
    private final OAuthConfig config;

    public OAuth20ServiceImpl(DefaultApi20 api, OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    public OAuth20ServiceImpl(String clientId, String clientSecret, String redirectUri) {
        this.api = new ConnsecApi20();
        this.config = new OAuthConfig(clientId, clientSecret, redirectUri);
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        if (this.api.getAccessTokenVerb().equals((Object)Verb.GET)) {
            request.addQuerystringParameter("client_id", this.config.getApiKey());
            request.addQuerystringParameter("client_secret", this.config.getApiSecret());
            request.addQuerystringParameter("code", verifier.getValue());
            request.addQuerystringParameter("redirect_uri", this.config.getCallback());
            if (this.config.hasScope()) {
                request.addQuerystringParameter("scope", this.config.getScope());
            }
        } else {
            request.getBodyParams().add("client_id", this.config.getApiKey());
            request.getBodyParams().add("client_secret", this.config.getApiSecret());
            request.getBodyParams().add("code", verifier.getValue());
            request.getBodyParams().add("redirect_uri", this.config.getCallback());
            request.getBodyParams().add("grant_type", this.api.getGrantType());
            if (this.config.hasScope()) {
                request.getBodyParams().add("scope", this.config.getScope());
            }
        }
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override
    public Token getRequestToken() {
        throw new UnsupportedOperationException("Unsupported operation, please use 'getAuthorizationUrl' and redirect your users there");
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signRequest(Token accessToken, OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }

    @Override
    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(this.config);
    }

    @Override
    public void signAccessTokenRequest(Token accessToken, OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }
}

