/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.model;

import com.connsec.client.utils.Preconditions;
import java.io.Serializable;
import java.util.Map;

public class Token
implements Serializable {
    private static final long serialVersionUID = 715000866082812683L;
    private String rawResponse;
    private Map<String, Object> responseObject;
    private String access_token;
    private String token;
    private String secret;
    private String refresh_token;
    private String expires_in;
    private String signature;
    private String token_type;
    private String id_token;
    private String sub_jwk;
    private String error;
    private String error_description;

    public Token() {
        this.rawResponse = null;
    }

    public Token(String token, String secret) {
        this(token, secret, null);
    }

    public Token(String token, String secret, String rawResponse) {
        Preconditions.checkNotNull(token, "Token can't be null");
        Preconditions.checkNotNull(secret, "Secret can't be null");
        this.token = token;
        this.secret = secret;
        this.rawResponse = rawResponse;
        this.responseObject = null;
    }

    public Token(String token, String secret, String rawResponse, Map<String, Object> responseObject) {
        this.token = token;
        this.secret = secret;
        this.rawResponse = rawResponse;
        this.responseObject = responseObject;
    }

    public String getAccess_token() {
        if (this.access_token == null || this.access_token.equals("")) {
            this.access_token = this.token;
        }
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public Map<String, Object> getResponseObject() {
        return this.responseObject;
    }

    public void setResponseObject(Map<String, Object> responseObject) {
        this.responseObject = responseObject;
    }

    public String getToken() {
        if (this.token == null) {
            this.token = this.access_token;
        }
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getRefresh_token() {
        return this.refresh_token;
    }

    public void setRefresh_token(String refresh_token) {
        this.refresh_token = refresh_token;
    }

    public String getExpires_in() {
        return this.expires_in;
    }

    public void setExpires_in(String expires_in) {
        this.expires_in = expires_in;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getToken_type() {
        return this.token_type;
    }

    public void setToken_type(String token_type) {
        this.token_type = token_type;
    }

    public String getId_token() {
        return this.id_token;
    }

    public void setId_token(String id_token) {
        this.id_token = id_token;
    }

    public String getSub_jwk() {
        return this.sub_jwk;
    }

    public void setSub_jwk(String sub_jwk) {
        this.sub_jwk = sub_jwk;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError_description() {
        return this.error_description;
    }

    public void setError_description(String error_description) {
        this.error_description = error_description;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public String getRawResponse() {
        if (this.rawResponse == null) {
            throw new IllegalStateException("This token object was not constructed by scribe and does not have a rawResponse");
        }
        return this.rawResponse;
    }

    public String toString() {
        return "Token [rawResponse=" + this.rawResponse + ", responseObject=" + this.responseObject + ", access_token=" + this.access_token + ", token=" + this.token + ", secret=" + this.secret + ", refresh_token=" + this.refresh_token + ", expires_in=" + this.expires_in + ", signature=" + this.signature + ", token_type=" + this.token_type + ", id_token=" + this.id_token + ", sub_jwk=" + this.sub_jwk + ", error=" + this.error + ", error_description=" + this.error_description + "]";
    }

    public boolean isEmpty() {
        return "".equals(this.token) && "".equals(this.secret);
    }

    public static Token empty() {
        return new Token("", "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token that = (Token)o;
        return this.token.equals(that.token) && this.secret.equals(that.secret);
    }

    public int hashCode() {
        return 31 * this.token.hashCode() + this.secret.hashCode();
    }
}

