/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.model;

import com.connsec.client.oauth.model.Parameter;
import com.connsec.client.utils.OAuthEncoder;
import com.connsec.client.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParameterList {
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String PARAM_SEPARATOR = "&";
    private static final String PAIR_SEPARATOR = "=";
    private static final String EMPTY_STRING = "";
    private final List<Parameter> params;

    public ParameterList() {
        this.params = new ArrayList<Parameter>();
    }

    ParameterList(List<Parameter> params) {
        this.params = new ArrayList<Parameter>(params);
    }

    public ParameterList(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.params.add(new Parameter(entry.getKey(), entry.getValue()));
        }
    }

    public void add(String key, String value) {
        this.params.add(new Parameter(key, value));
    }

    public String appendTo(String url) {
        Preconditions.checkNotNull(url, "Cannot append to null URL");
        String queryString = this.asFormUrlEncodedString();
        if (queryString.equals(EMPTY_STRING)) {
            return url;
        }
        url = String.valueOf(url) + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = String.valueOf(url) + queryString;
        return url;
    }

    public String asOauthBaseString() {
        return OAuthEncoder.encode(this.asFormUrlEncodedString());
    }

    public String asFormUrlEncodedString() {
        if (this.params.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        for (Parameter p : this.params) {
            builder.append('&').append(p.asUrlEncodedPair());
        }
        return builder.toString().substring(1);
    }

    public void addAll(ParameterList other) {
        this.params.addAll(other.params);
    }

    public void addQuerystring(String queryString) {
        if (queryString != null && queryString.length() > 0) {
            String[] stringArray = queryString.split(PARAM_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] pair = param.split(PAIR_SEPARATOR);
                String key = OAuthEncoder.decode(pair[0]);
                String value = pair.length > 1 ? OAuthEncoder.decode(pair[1]) : EMPTY_STRING;
                this.params.add(new Parameter(key, value));
                ++n2;
            }
        }
    }

    public boolean contains(Parameter param) {
        return this.params.contains(param);
    }

    public int size() {
        return this.params.size();
    }

    public ParameterList sort() {
        ParameterList sorted = new ParameterList(this.params);
        Collections.sort(sorted.params);
        return sorted;
    }
}

