/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.extractors;

import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.utils.OAuthEncoder;
import com.connsec.client.utils.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenExtractor20Impl
implements AccessTokenExtractor {
    private static final String TOKEN_REGEX = "access_token=([^&]+)";
    private static final String EMPTY_SECRET = "";

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
        if (matcher.find()) {
            String token = OAuthEncoder.decode(matcher.group(1));
            return new Token(token, EMPTY_SECRET, response);
        }
        throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
    }
}

