/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.extractors;

import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.utils.Preconditions;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class QQTokenExtractor
implements AccessTokenExtractor {
    static final Logger log = Logger.getLogger(QQTokenExtractor.class);

    @Override
    public Token extract(String response) {
        log.debug((Object)("extract a token from : " + response));
        Preconditions.checkEmptyString(response, "Cannot extract a token from a null or empty String");
        try {
            String[] fields = response.split("&");
            HashMap<String, Object> tokenMap = new HashMap<String, Object>();
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                String[] sfield = field.split("=");
                if (sfield.length == 2) {
                    tokenMap.put(sfield[0], sfield[1]);
                }
                ++n2;
            }
            log.debug((Object)("token map : " + tokenMap));
            Token token = new Token(tokenMap.get("access_token").toString(), "", response, tokenMap);
            return token;
        }
        catch (Exception e) {
            throw new OAuthException("Cannot extract an acces token. Response was: " + response);
        }
    }
}

