/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.client;

import com.connsec.client.oauth.client.AuthorizationHeader;
import com.connsec.client.oauth.client.OIDCUserInfo;
import com.connsec.client.oauth.client.UserInfo;
import com.connsec.client.oauth.model.OAuthRequest;
import com.connsec.client.oauth.model.Response;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.oauth.model.Verb;
import com.connsec.client.utils.JsonUtils;
import com.connsec.client.utils.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestClient {
    private static Log log = LogFactory.getLog(RestClient.class);
    public static String OAUTH_V20_USERINFO_URI = "http://login.connsec.com/maxkey/api/oauth/v20/me";
    public static String OAUTH_V10A_USERINFO_URI = "http://login.connsec.com/maxkey/api/oauth/v10a/me";
    public static String OPENID_CONNECT_V10A_USERINFO_URI = "http://login.connsec.com/maxkey/api/connect/v10/userinfo";
    private Verb method = Verb.GET;
    private OAuthRequest request;

    public RestClient(String url) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        this.request = new OAuthRequest(this.method, url);
    }

    public RestClient(String url, String accessToken) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        this.request = new OAuthRequest(this.method, url);
        this.addParameter("access_token", accessToken);
    }

    public RestClient(String url, Verb method) {
        Preconditions.checkEmptyString(url, "Invalid request url");
        if (method != null) {
            this.method = method;
        }
        this.request = new OAuthRequest(method, url);
    }

    public void signAccessToken(Token accessToken) {
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.addParameter("access_token", accessToken.getToken());
    }

    public void addParameter(String name, String value) {
        Preconditions.checkEmptyString(name, "parameter name is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        if (Verb.GET == this.method) {
            this.request.addQuerystringParameter(name, value);
        } else if (Verb.POST == this.method) {
            this.request.addBodyParameter(name, value);
        }
    }

    public void addHeader(String name, String value) {
        Preconditions.checkEmptyString(name, "parameter name is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addHeader(name, value);
    }

    public Response execute() {
        return this.request.send();
    }

    public Token requestAccessToken() {
        String tokenString = this.execute().getBody();
        Token token = JsonUtils.gson2Object(tokenString, Token.class);
        log.debug((Object)("Request token : " + token));
        return token;
    }

    public void addBasicAuthorizationHeader(String username, String password) {
        Preconditions.checkEmptyString(username, "parameter username is null");
        Preconditions.checkEmptyString(password, "parameter password is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBasic(username, password));
    }

    public void addBearerAuthorizationHeader(String bearer) {
        Preconditions.checkEmptyString(bearer, "parameter bearer is null");
        Preconditions.checkNotNull(this.request, "OAuthRequest is null");
        this.request.addHeader(AuthorizationHeader.AUTHORIZATION_HEADERNAME, AuthorizationHeader.createBearer(bearer));
    }

    public UserInfo getUserInfo(String accessToken) {
        this.addParameter("access_token", accessToken);
        Response response = this.execute();
        log.debug((Object)("Request UserInfo : " + response.getBody()));
        System.out.println("Request UserInfo : " + response.getBody());
        UserInfo userInfo = JsonUtils.gson2Object(response.getBody(), UserInfo.class);
        userInfo.setResponseString(response.getBody());
        if (userInfo.getError() != null) {
            "".equals(userInfo.getError().trim());
        }
        log.debug((Object)("UserInfo : " + userInfo));
        return userInfo;
    }

    public OIDCUserInfo getOIDCUserInfo(String accessToken) {
        this.addHeader("Authorization", accessToken);
        Response response = this.execute();
        log.debug((Object)("Request OIDCUserInfo : " + response.getBody()));
        OIDCUserInfo userInfo = JsonUtils.gson2Object(response.getBody(), OIDCUserInfo.class);
        userInfo.setResponseString(response.getBody());
        if (userInfo.getError() != null) {
            "".equals(userInfo.getError().trim());
        }
        log.debug((Object)("UserInfo : " + userInfo));
        return userInfo;
    }

    public void addRestContent(String content) {
        this.request.addRestContent(content);
    }

    public void addRestObject(Object content) {
        this.request.addRestObject(content);
    }

    public void addRestContent(byte[] content) {
        this.request.addRestContent(content);
    }
}

