/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.client;

import com.connsec.client.crypto.Base64Utils;

public class AuthorizationHeader {
    public static String AUTHORIZATION_HEADERNAME = "Authorization";
    public static String BASIC = "Basic ";
    public static String BEARER = "Bearer ";

    public static String createBasic(String username, String password) {
        String authUserPass = String.valueOf(username) + ":" + password;
        String encodedAuthUserPass = Base64Utils.encode(authUserPass);
        return String.valueOf(BASIC) + encodedAuthUserPass;
    }

    public static String[] resolveBasic(String basic) {
        if (AuthorizationHeader.isBasic(basic)) {
            String[] userPass = basic.split(" ");
            String decodeUserPass = Base64Utils.decode(userPass[1]);
            return decodeUserPass.split(":");
        }
        return null;
    }

    public static boolean isBasic(String basic) {
        return basic.startsWith(BASIC);
    }

    public static String resolveBearer(String bearer) {
        if (AuthorizationHeader.isBearer(bearer)) {
            return bearer.split(" ")[1];
        }
        return null;
    }

    public static String createBearer(String bearer) {
        return String.valueOf(BEARER) + bearer;
    }

    public static boolean isBearer(String bearer) {
        return bearer.startsWith(BEARER);
    }
}

