/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.builder.api;

import com.connsec.client.oauth.builder.api.Api;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.extractors.BaseStringExtractor;
import com.connsec.client.oauth.extractors.BaseStringExtractorImpl;
import com.connsec.client.oauth.extractors.HeaderExtractor;
import com.connsec.client.oauth.extractors.HeaderExtractorImpl;
import com.connsec.client.oauth.extractors.RequestTokenExtractor;
import com.connsec.client.oauth.extractors.TokenExtractorImpl;
import com.connsec.client.oauth.model.OAuthConfig;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.oauth.model.Verb;
import com.connsec.client.oauth.oauth.OAuth10aServiceImpl;
import com.connsec.client.oauth.oauth.OAuthService;
import com.connsec.client.oauth.services.HMACSha1SignatureService;
import com.connsec.client.oauth.services.SignatureService;
import com.connsec.client.oauth.services.TimestampService;
import com.connsec.client.oauth.services.TimestampServiceImpl;

public abstract class DefaultApi10a
implements Api {
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new TokenExtractorImpl();
    }

    public BaseStringExtractor getBaseStringExtractor() {
        return new BaseStringExtractorImpl();
    }

    public HeaderExtractor getHeaderExtractor() {
        return new HeaderExtractorImpl();
    }

    public RequestTokenExtractor getRequestTokenExtractor() {
        return new TokenExtractorImpl();
    }

    public SignatureService getSignatureService() {
        return new HMACSha1SignatureService();
    }

    public TimestampService getTimestampService() {
        return new TimestampServiceImpl();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public Verb getRequestTokenVerb() {
        return Verb.POST;
    }

    public abstract String getRequestTokenEndpoint();

    public abstract String getAccessTokenEndpoint();

    public abstract String getAuthorizationUrl(Token var1);

    @Override
    public OAuthService createService(OAuthConfig config) {
        return new OAuth10aServiceImpl(this, config);
    }
}

