/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.builder.api;

import com.connsec.client.oauth.builder.api.DefaultApi20;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.extractors.GsonJsonTokenExtractor;
import com.connsec.client.oauth.model.OAuthConfig;
import com.connsec.client.oauth.model.Verb;
import com.connsec.client.utils.OAuthEncoder;
import com.connsec.client.utils.Preconditions;

public class ConnsecApi20
extends DefaultApi20 {
    private static final String DEFAULT_WEB_URL = "http://login.connsec.com/maxkey";
    private static final String AUTHORIZATION_URL = "%s/oauth/v20/authorize?client_id=%s&response_type=code&redirect_uri=%s&approval_prompt=auto";
    private static final String SCOPED_AUTHORIZE_URL = String.format("%s&scope=%%s", "%s/oauth/v20/authorize?client_id=%s&response_type=code&redirect_uri=%s&approval_prompt=auto");

    @Override
    public String getAccessTokenEndpoint() {
        return String.valueOf(this.getWebUrl()) + "/oauth/v20/token?grant_type=authorization_code";
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl(config.getCallback(), "Must provide a valid url as callback. ParaSecure does not support OOB");
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, this.getWebUrl(), config.getApiKey(), OAuthEncoder.encode(config.getCallback()), OAuthEncoder.encode(config.getScope()));
        }
        return String.format(AUTHORIZATION_URL, this.getWebUrl(), config.getApiKey(), OAuthEncoder.encode(config.getCallback()));
    }

    @Override
    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    @Override
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new GsonJsonTokenExtractor();
    }

    private String getWebUrl() {
        String webUrl = null;
        if (webUrl == null || "".equals(webUrl)) {
            webUrl = DEFAULT_WEB_URL;
        }
        return webUrl;
    }

    @Override
    public String getGrantType() {
        return "authorization_code";
    }
}

