/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.crypto;

import com.connsec.client.crypto.HexUtils;
import com.connsec.client.utils.StringGenerator;
import com.sun.crypto.provider.SunJCE;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.LogFactory;

public final class ReciprocalUtils {
    private static final String defaultKey = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static byte[] encode(byte[] simpleBytes, SecretKey secretKey, String algorithm) {
        byte[] byteFinal = null;
        try {
            Cipher ecipher = Cipher.getInstance(secretKey.getAlgorithm());
            ecipher.init(1, secretKey);
            byteFinal = ecipher.doFinal(simpleBytes);
            return byteFinal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encode(String simple, String secretKey, String algorithm) {
        if (ReciprocalUtils.keyLengthCheck(secretKey, algorithm)) {
            SecretKey key = ReciprocalUtils.generatorKey(secretKey, algorithm);
            try {
                return ReciprocalUtils.encode(simple.getBytes("UTF-8"), key, algorithm);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] decoder(byte[] ciphersBytes, SecretKey secretKey, String algorithm) {
        byte[] byteFinal = null;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, secretKey);
            byte[] byArray = byteFinal = cipher.doFinal(ciphersBytes);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Object cipher = null;
        }
        return null;
    }

    public static String decoder(byte[] ciphersBytes, String secretKey, String algorithm) {
        if (ReciprocalUtils.keyLengthCheck(secretKey, algorithm)) {
            SecretKey key = ReciprocalUtils.generatorKey(secretKey, algorithm);
            try {
                return new String(ReciprocalUtils.decoder(ciphersBytes, key, algorithm), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static SecretKey generatorDefaultKey(String algorithm) {
        try {
            Security.addProvider(new SunJCE());
            KeyGenerator _generator = KeyGenerator.getInstance(algorithm);
            _generator.init(new SecureRandom(defaultKey.getBytes()));
            SecretKey key = _generator.generateKey();
            _generator = null;
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SecretKey generatorKey(String secretKey, String algorithm) {
        try {
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), algorithm);
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean keyLengthCheck(String secretKey, String algorithm) {
        boolean lengthCheck = false;
        if (algorithm.equals("DES")) {
            if (secretKey.length() == 8) {
                lengthCheck = true;
            } else {
                LogFactory.getLog(ReciprocalUtils.class).debug((Object)("key length is " + secretKey.getBytes().length + " ,must lequal 8"));
            }
        } else if (algorithm.equals("DESede")) {
            if (secretKey.length() == 24) {
                lengthCheck = true;
            } else {
                LogFactory.getLog(ReciprocalUtils.class).debug((Object)("key length is " + secretKey.getBytes().length + " ,must equal 24"));
            }
        } else if (algorithm.equals("AES")) {
            if (secretKey.length() == 16) {
                lengthCheck = true;
            } else {
                LogFactory.getLog(ReciprocalUtils.class).debug((Object)("key length is " + secretKey.getBytes().length + " ,must equal 16"));
            }
        } else if (algorithm.equals("Blowfish")) {
            if (secretKey.length() <= 16) {
                lengthCheck = true;
            } else {
                LogFactory.getLog(ReciprocalUtils.class).debug((Object)("key length is " + secretKey.getBytes().length + " ,must be less then 16"));
            }
        }
        return lengthCheck;
    }

    public static byte[] encodeByDefaultKey(String simple, String algorithm) {
        SecretKey key = ReciprocalUtils.generatorDefaultKey(algorithm);
        return ReciprocalUtils.encode(simple.getBytes(), key, algorithm);
    }

    public static String encode2HexByDefaultKey(String simple, String algorithm) {
        byte[] byteFinal = ReciprocalUtils.encodeByDefaultKey(simple, algorithm);
        String cipherHex = HexUtils.bytes2HexString(byteFinal);
        return cipherHex;
    }

    public static byte[] decoderByDefaultKey(byte[] byteCiphers, String algorithm) {
        SecretKey key = ReciprocalUtils.generatorDefaultKey(algorithm);
        return ReciprocalUtils.decoder(byteCiphers, key, algorithm);
    }

    public static String decoderHexByDefaultKey(String ciphers, String algorithm) {
        byte[] byteSimple = HexUtils.hex2Bytes(ciphers);
        byte[] byteFinal = ReciprocalUtils.decoderByDefaultKey(byteSimple, algorithm);
        String simple = null;
        try {
            simple = new String(byteFinal, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return simple;
    }

    public static String encode(String simple) {
        return ReciprocalUtils.encode2HexByDefaultKey(simple, "AES");
    }

    public static String decoder(String ciphers) {
        return ReciprocalUtils.decoderHexByDefaultKey(ciphers, "AES");
    }

    public static String generateKey(String algorithm) {
        if (algorithm.equals("DES")) {
            return new StringGenerator(8).randomGenerate();
        }
        if (algorithm.equals("AES")) {
            return new StringGenerator(16).randomGenerate();
        }
        if (algorithm.equals("Blowfish")) {
            return new StringGenerator(16).randomGenerate();
        }
        if (algorithm.equals("DESede")) {
            return new StringGenerator(24).randomGenerate();
        }
        return new StringGenerator().uniqueGenerate();
    }

    public final class Algorithm {
        public static final String DES = "DES";
        public static final String DESede = "DESede";
        public static final String Blowfish = "Blowfish";
        public static final String AES = "AES";
    }
}

