/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.artifact;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.artifact.BasicSAMLArtifactMapEntry;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.util.storage.StorageService;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSAMLArtifactMap
implements SAMLArtifactMap {
    private final Logger log = LoggerFactory.getLogger(BasicSAMLArtifactMap.class);
    private ParserPool parserPool;
    private StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> artifactStore;
    private String partition;
    private long artifactLifetime;

    public BasicSAMLArtifactMap(ParserPool parser, StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, long lifetime) {
        this.parserPool = parser;
        this.artifactStore = storage;
        this.partition = "artifact";
        this.artifactLifetime = lifetime;
    }

    public BasicSAMLArtifactMap(StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, String storageParition, long lifetime) {
        this.artifactStore = storage;
        this.partition = !DatatypeHelper.isEmpty((String)storageParition) ? DatatypeHelper.safeTrim((String)storageParition) : "artifact";
        this.artifactLifetime = lifetime;
    }

    @Override
    public boolean contains(String artifact) {
        return this.artifactStore.contains(this.partition, (Object)artifact);
    }

    @Override
    public SAMLArtifactMap.SAMLArtifactMapEntry get(String artifact) {
        BasicSAMLArtifactMapEntry entry = (BasicSAMLArtifactMapEntry)this.artifactStore.get(this.partition, (Object)artifact);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            this.remove(artifact);
            return null;
        }
        try {
            Element samlMessageElem = this.parserPool.parse((Reader)new StringReader(entry.getSeralizedMessage())).getDocumentElement();
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(samlMessageElem);
            entry.setSAMLMessage((SAMLObject)unmarshaller.unmarshall(samlMessageElem));
        }
        catch (XMLParserException e) {
            this.log.error("Unable to parse serialized SAML message", (Throwable)e);
        }
        catch (UnmarshallingException e) {
            this.log.error("Unable to unmarshall serialized SAML message", (Throwable)e);
        }
        return entry;
    }

    @Override
    public void put(String artifact, String relyingPartyId, String issuerId, SAMLObject samlMessage) throws MarshallingException {
        StringWriter writer = new StringWriter();
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)samlMessage);
        XMLHelper.writeNode((Node)marshaller.marshall((XMLObject)samlMessage), (Writer)writer);
        BasicSAMLArtifactMapEntry artifactEntry = new BasicSAMLArtifactMapEntry(artifact, issuerId, relyingPartyId, writer.toString(), this.artifactLifetime);
        this.artifactStore.put(this.partition, (Object)artifact, (Object)artifactEntry);
    }

    @Override
    public void remove(String artifact) {
        this.artifactStore.remove(this.partition, (Object)artifact);
    }
}

