/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.builder.api;

import org.maxkey.client.http.HttpVerb;
import org.maxkey.client.oauth.builder.api.DefaultApi20;
import org.maxkey.client.oauth.extractors.AccessTokenExtractor;
import org.maxkey.client.oauth.extractors.GsonJsonTokenExtractor;
import org.maxkey.client.oauth.model.OAuthConfig;

public class ConnsecPasswordApi20
extends DefaultApi20 {
    private String accessTokenUrl;
    private String grantType = "password";
    private String scope = "&scope=%s";
    private String accessTokenMethod = "POST";
    private static final String AUTHORIZE_PARAM = "&client_id=%s&client_secret=%s&username=%s&password=%s";

    public ConnsecPasswordApi20(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    @Override
    public HttpVerb getAccessTokenVerb() {
        if (this.accessTokenMethod != null && this.accessTokenMethod.toUpperCase().equals("POST")) {
            return HttpVerb.POST;
        }
        return HttpVerb.GET;
    }

    @Override
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new GsonJsonTokenExtractor();
    }

    @Override
    public String getAccessTokenEndpoint() {
        if (this.accessTokenUrl.indexOf("?") > 0) {
            return String.valueOf(this.accessTokenUrl) + "&grant_type=" + this.grantType + AUTHORIZE_PARAM;
        }
        return String.valueOf(this.accessTokenUrl) + "?grant_type=" + this.grantType + AUTHORIZE_PARAM;
    }

    public String getAuthorizationUrl(OAuthConfig config, String username, String password) {
        return String.format(this.getAccessTokenEndpoint(), config.getApiKey(), config.getApiSecret(), username, password);
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String toString() {
        return "OAuthApi20 [accessTokenUrl=" + this.accessTokenUrl + ", grantType=" + this.grantType + ", scope=" + this.scope + "]";
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig config) {
        return "";
    }

    @Override
    public String getGrantType() {
        return "authorization_code";
    }
}

