/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.services;

import com.connsec.client.oauth.exceptions.OAuthSignatureException;
import com.connsec.client.oauth.services.SignatureService;
import com.connsec.client.utils.HttpEncoder;
import com.connsec.client.utils.Preconditions;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "PLAINTEXT";

    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString((String)apiSecret, (String)"Api secret cant be null or empty string");
            return HttpEncoder.encode((String)apiSecret) + '&' + HttpEncoder.encode((String)tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    public String getSignatureMethod() {
        return METHOD;
    }
}

