/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.utils;

import com.connsec.client.utils.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public abstract class StreamUtils {
    public static String getStreamContents(InputStream is) throws IOException {
        Preconditions.checkNotNull(is, "Cannot get String from a null object");
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStreamReader in = new InputStreamReader(is, "UTF-8");){
            int read;
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return out.toString();
    }

    public static String getGzipStreamContents(InputStream is) throws IOException {
        Preconditions.checkNotNull(is, "Cannot get String from a null object");
        GZIPInputStream gis = new GZIPInputStream(is);
        return StreamUtils.getStreamContents(gis);
    }
}

