/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.oauth;

import com.connsec.client.http.HttpVerb;
import com.connsec.client.http.Response;
import com.connsec.client.oauth.builder.ServiceBuilder;
import com.connsec.client.oauth.builder.api.ConnsecPasswordApi20;
import com.connsec.client.oauth.model.OAuthConfig;
import com.connsec.client.oauth.model.OAuthRequest;
import com.connsec.client.oauth.model.Token;
import com.connsec.client.oauth.oauth.OAuthService;

public class OAuthPasswordService {
    private OAuthConfig config;
    private ConnsecPasswordApi20 passwordApi20;

    public OAuthPasswordService() {
    }

    public OAuthPasswordService(OAuthConfig config, ConnsecPasswordApi20 passwordApi20) {
        this.passwordApi20 = passwordApi20;
        this.config = config;
    }

    public Token getAccessToken(String username, String password) {
        try {
            String accessTokenUrl = this.passwordApi20.getAuthorizationUrl(this.config, username, password);
            System.out.println(accessTokenUrl);
            OAuthRequest oauthRequest = new OAuthRequest(HttpVerb.GET, accessTokenUrl);
            Response response = oauthRequest.send();
            return this.passwordApi20.getAccessTokenExtractor().extract(response.getBody());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Response sendRequest(Token accessToken, HttpVerb requestMethod, String requestUrl) {
        OAuthRequest oauthRequest = new OAuthRequest(requestMethod, requestUrl);
        ServiceBuilder builder = new ServiceBuilder().provider(this.passwordApi20).apiKey(this.config.getApiKey()).apiSecret(this.config.getApiSecret()).callback(this.config.getCallback());
        OAuthService oAuthService = builder.build();
        oAuthService.signRequest(accessToken, oauthRequest);
        return oauthRequest.send();
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public void setConfig(OAuthConfig config) {
        this.config = config;
    }

    public ConnsecPasswordApi20 getPasswordApi20() {
        return this.passwordApi20;
    }

    public void setPasswordApi20(ConnsecPasswordApi20 passwordApi20) {
        this.passwordApi20 = passwordApi20;
    }
}

