/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.builder.api;

import com.connsec.client.http.HttpVerb;
import com.connsec.client.oauth.builder.api.DefaultApi20;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.extractors.GsonJsonTokenExtractor;
import com.connsec.client.oauth.extractors.QQTokenExtractor;
import com.connsec.client.oauth.model.OAuthConfig;
import com.connsec.client.utils.HttpEncoder;

public class OAuthApi20
extends DefaultApi20 {
    private String authorizeUrl;
    private String accessTokenUrl;
    private String grantType = "authorization_code";
    private String scope = "&scope=%s";
    private String accessTokenMethod = "POST";

    public OAuthApi20(String authorizeUrl, String accessTokenUrl) {
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
    }

    public OAuthApi20(String authorizeUrl, String accessTokenUrl, String accessTokenMethod) {
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.accessTokenMethod = accessTokenMethod;
    }

    public OAuthApi20(String authorizeUrl, String accessTokenUrl, String grantType, String accessTokenMethod) {
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.grantType = grantType;
        this.accessTokenMethod = accessTokenMethod;
    }

    public OAuthApi20(String authorizeUrl, String accessTokenUrl, String grantType, String accessTokenMethod, String scope) {
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.grantType = grantType;
        this.accessTokenMethod = accessTokenMethod;
        this.scope = scope;
    }

    @Override
    public HttpVerb getAccessTokenVerb() {
        if (this.accessTokenMethod != null && this.accessTokenMethod.toUpperCase().equals("POST")) {
            return HttpVerb.POST;
        }
        return HttpVerb.GET;
    }

    @Override
    public AccessTokenExtractor getAccessTokenExtractor() {
        if (this.accessTokenUrl.indexOf("qq") > -1) {
            return new QQTokenExtractor();
        }
        return new GsonJsonTokenExtractor();
    }

    @Override
    public String getAccessTokenEndpoint() {
        if (this.accessTokenUrl.indexOf("?") > 0) {
            return String.valueOf(this.accessTokenUrl) + "&grant_type=" + this.grantType;
        }
        return String.valueOf(this.accessTokenUrl) + "?grant_type=" + this.grantType;
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig config) {
        if (config.hasScope()) {
            return String.format(String.valueOf(this.authorizeUrl) + this.scope, config.getApiKey(), HttpEncoder.encode(config.getCallback()), HttpEncoder.encode(config.getScope()));
        }
        return String.format(this.authorizeUrl, config.getApiKey(), HttpEncoder.encode(config.getCallback()));
    }

    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    @Override
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String toString() {
        return "OAuthApi20 [authorizeUrl=" + this.authorizeUrl + ", accessTokenUrl=" + this.accessTokenUrl + ", grantType=" + this.grantType + ", scope=" + this.scope + "]";
    }
}

