/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.jwt.signer.service.impl;

import com.connsec.oidc.jwt.signer.service.JwtSigningAndValidationService;
import com.connsec.oidc.jwt.signer.service.impl.DefaultJwtSigningAndValidationService;
import com.google.common.collect.ImmutableMap;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import org.apache.log4j.Logger;

public class SymmetricSigningAndValidationServiceBuilder {
    static final Logger logger = Logger.getLogger(SymmetricSigningAndValidationServiceBuilder.class);
    public static final String SYMMETRIC_KEY = "SYMMETRIC-KEY";

    public JwtSigningAndValidationService serviceBuilder(String sharedSecret) {
        logger.debug((Object)("shared Secret : " + sharedSecret));
        logger.debug((Object)"Symmetric Id : SYMMETRIC-KEY");
        if (sharedSecret == null) {
            logger.error((Object)"Couldn't create symmetric SigningAndValidation");
            return null;
        }
        OctetSequenceKey jwk = new OctetSequenceKey(Base64URL.encode((String)sharedSecret), KeyUse.SIGNATURE, null, null, SYMMETRIC_KEY, null, null, null);
        ImmutableMap keys = ImmutableMap.of((Object)SYMMETRIC_KEY, (Object)jwk);
        try {
            DefaultJwtSigningAndValidationService symmetricSigningAndValidationService = new DefaultJwtSigningAndValidationService((Map<String, JWK>)keys);
            return symmetricSigningAndValidationService;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }
}

