/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.jose.keystore;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import org.springframework.core.io.Resource;

public class JWKSetKeyStore {
    private JWKSet jwkSet;
    private Resource location;

    public JWKSetKeyStore() {
    }

    public JWKSetKeyStore(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
        this.initializeJwkSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeJwkSet() {
        if (this.jwkSet != null) return;
        if (this.location == null) throw new IllegalArgumentException("Key store must be initialized with at least one of a jwkSet or a location.");
        if (!this.location.exists() || !this.location.isReadable()) throw new IllegalArgumentException("Key Set resource could not be read: " + this.location);
        try {
            String s = CharStreams.toString((Readable)new InputStreamReader(this.location.getInputStream(), Charsets.UTF_8));
            this.jwkSet = JWKSet.parse((String)s);
            return;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Key Set resource could not be read: " + this.location);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Key Set resource could not be parsed: " + this.location);
        }
    }

    public JWKSet getJwkSet() {
        return this.jwkSet;
    }

    public void setJwkSet(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
        this.initializeJwkSet();
    }

    public Resource getLocation() {
        return this.location;
    }

    public void setLocation(Resource location) {
        this.location = location;
        this.initializeJwkSet();
    }

    public List<JWK> getKeys() {
        if (this.jwkSet == null) {
            this.initializeJwkSet();
        }
        return this.jwkSet.getKeys();
    }
}

