/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.ltpa;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.maxkey.client.crypto.Base64Utils;
import org.maxkey.client.crypto.ReciprocalUtils;
import org.maxkey.client.utils.JsonUtils;

public class LtpaUtils {
    public static String readLtpa(HttpServletRequest request, String ltpaDomain, String ltpaName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equalsIgnoreCase(ltpaName)) {
                    return cookies[i].getValue();
                }
                ++i;
            }
        }
        return null;
    }

    public static String decode(String ltpaString, String algorithmKey, String algorithm) {
        String token = ReciprocalUtils.decoder(Base64Utils.base64UrlDecode(ltpaString), algorithmKey, algorithm);
        try {
            token = new String(Hex.decodeHex((char[])token.toCharArray()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        return token;
    }

    public static HashMap<String, Object> parseLtpaJson(String token) {
        HashMap tokenMap = new HashMap();
        tokenMap = (HashMap)JsonUtils.gson2Object(token, tokenMap.getClass());
        return tokenMap;
    }

    public static void main(String[] args) {
        String token = "ICHQ%2F1Tdzw214UNw9fKEjRNFbvOlGdXyxVjF9I7kwEo%3D";
        String tokenString = LtpaUtils.decode(token, "x8zPbCya", "DES");
        System.out.println(tokenString);
    }
}

