/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.maxkey.client.http.Parameter;
import org.maxkey.client.utils.HttpEncoder;
import org.maxkey.client.utils.Preconditions;

public class ParameterList {
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String PARAM_SEPARATOR = "&";
    private static final String PAIR_SEPARATOR = "=";
    private static final String EMPTY_STRING = "";
    private final List<Parameter> params;

    public ParameterList() {
        this.params = new ArrayList<Parameter>();
    }

    ParameterList(List<Parameter> params) {
        this.params = new ArrayList<Parameter>(params);
    }

    public ParameterList(Map<String, String> map) {
        this();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.params.add(new Parameter(entry.getKey(), entry.getValue()));
            }
        }
    }

    public void add(String key, String value) {
        this.params.add(new Parameter(key, value));
    }

    public String appendTo(String url) {
        Preconditions.checkNotNull(url, "Cannot append to null URL");
        String queryString = this.asFormUrlEncodedString();
        if (queryString.equals(EMPTY_STRING)) {
            return url;
        }
        return String.valueOf(url) + (url.indexOf(63) == -1 ? Character.valueOf('?') : PARAM_SEPARATOR) + queryString;
    }

    public String asOauthBaseString() {
        return HttpEncoder.encode(this.asFormUrlEncodedString());
    }

    public String asFormUrlEncodedString() {
        if (this.params.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        for (Parameter p : this.params) {
            builder.append(PARAM_SEPARATOR).append(p.asUrlEncodedPair());
        }
        return builder.substring(1);
    }

    public void addAll(ParameterList other) {
        this.params.addAll(other.getParams());
    }

    public void addQuerystring(String queryString) {
        if (queryString != null && !queryString.isEmpty()) {
            String[] stringArray = queryString.split(PARAM_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                try {
                    String[] pair = param.split(PAIR_SEPARATOR);
                    String key = HttpEncoder.decode(pair[0]);
                    String value = pair.length > 1 ? HttpEncoder.decode(pair[1]) : EMPTY_STRING;
                    this.params.add(new Parameter(key, value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public boolean contains(Parameter param) {
        return this.params.contains(param);
    }

    public int size() {
        return this.params.size();
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public ParameterList sort() {
        ParameterList sorted = new ParameterList(this.params);
        Collections.sort(sorted.getParams());
        return sorted;
    }
}

