/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.utils;

import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class HttpEncoder {
    private static final String CHARSET = "UTF-8";
    private static final Map<String, String> ENCODING_RULES;

    public static String encode(String plain) {
        String encoded;
        Preconditions.checkNotNull((Object)plain, (String)"Cannot encode null object");
        try {
            encoded = URLEncoder.encode(plain, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Charset not found while encoding string: UTF-8", (Exception)uee);
        }
        for (Map.Entry rule : ENCODING_RULES.entrySet()) {
            encoded = HttpEncoder.applyRule((String)encoded, (String)((String)rule.getKey()), (String)((String)rule.getValue()));
        }
        return encoded;
    }

    private static String applyRule(String encoded, String toReplace, String replacement) {
        return encoded.replaceAll(Pattern.quote(toReplace), replacement);
    }

    public static String decode(String encoded) throws UnsupportedEncodingException {
        Preconditions.checkNotNull((Object)encoded, (String)"Cannot decode null object");
        return URLDecoder.decode(encoded, "UTF-8");
    }

    static {
        HashMap<String, String> rules = new HashMap<String, String>();
        rules.put("*", "%2A");
        rules.put("+", "%20");
        rules.put("%7E", "~");
        ENCODING_RULES = Collections.unmodifiableMap(rules);
    }
}

