/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.JpaBaseService;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlProviderQuery<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(SqlProviderQuery.class);

    public String get(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        MapperMetadata.buildColumnList(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(MapperMetadata.getTableName(entityClass)) + MapperMetadata.SQL_TYPE.GET_SQL)) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(MapperMetadata.getTableName(entityClass)) + MapperMetadata.SQL_TYPE.GET_SQL);
        }
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entityClass.getSimpleName());
        SQL sql = new SQL();
        sql.SELECT(this.selectColumnMapper(entityClass));
        sql.FROM(String.valueOf(MapperMetadata.getTableName(entityClass)) + " sel_tmp_table ");
        sql.WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " = #{" + idFieldColumnMapper.getFieldName() + "}");
        String getSql = sql.toString();
        _logger.trace("Get SQL \n" + getSql);
        MapperMetadata.sqlsMap.put(String.valueOf(MapperMetadata.getTableName(entityClass)) + MapperMetadata.SQL_TYPE.GET_SQL, getSql);
        return getSql;
    }

    public String findAll(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get(MapperMetadata.ENTITY_CLASS);
        MapperMetadata.buildColumnList(entityClass);
        if (MapperMetadata.sqlsMap.containsKey(String.valueOf(MapperMetadata.getTableName(entityClass)) + MapperMetadata.SQL_TYPE.FINDALL_SQL)) {
            return (String)MapperMetadata.sqlsMap.get(String.valueOf(MapperMetadata.getTableName(entityClass)) + MapperMetadata.SQL_TYPE.FINDALL_SQL);
        }
        SQL sql = new SQL();
        sql.SELECT(this.selectColumnMapper(entityClass));
        sql.FROM(String.valueOf(MapperMetadata.getTableName(entityClass)) + " sel_tmp_table ");
        String findAllSql = sql.toString();
        _logger.trace("Find All SQL \n" + findAllSql);
        MapperMetadata.sqlsMap.put(String.valueOf(MapperMetadata.getTableName(entityClass)) + MapperMetadata.SQL_TYPE.FINDALL_SQL, findAllSql);
        return findAllSql;
    }

    public String execute(T entity) {
        MapperMetadata.buildColumnList(entity.getClass());
        SQL sql = new SQL();
        sql.SELECT(this.selectColumnMapper(entity.getClass()));
        sql.FROM(String.valueOf(MapperMetadata.getTableName(entity.getClass())) + " sel_tmp_table ");
        for (FieldColumnMapper fieldColumnMapper : (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName())) {
            String fieldValue = BeanUtil.getValue(entity, fieldColumnMapper.getFieldName());
            String fieldType = fieldColumnMapper.getFieldType().toLowerCase();
            _logger.trace("ColumnName " + fieldColumnMapper.getColumnName() + " , FieldType " + fieldType + " , value " + fieldValue);
            if (fieldValue == null || fieldType.equals("string") && fieldValue.equals("") || fieldType.startsWith("byte") && fieldValue == null || fieldType.equals("int") && fieldValue.equals("0") || fieldType.equals("long") && fieldValue.equals("0") || fieldType.equals("integer") && fieldValue.equals("0") || fieldType.equals("float") && fieldValue.equals("0.0") || fieldType.equals("double") && fieldValue.equals("0.0")) continue;
            sql.WHERE(String.valueOf(fieldColumnMapper.getColumnName()) + "=#{" + fieldColumnMapper.getFieldName() + "}");
        }
        return sql.toString();
    }

    public String selectColumnMapper(Class<?> entityClass) {
        StringBuffer selectColumn = new StringBuffer("sel_tmp_table.* ");
        int columnCount = 0;
        for (FieldColumnMapper fieldColumnMapper : (List)MapperMetadata.fieldsMap.get(entityClass.getSimpleName())) {
            ++columnCount;
            if (!fieldColumnMapper.getColumnName().equalsIgnoreCase(fieldColumnMapper.getFieldName())) {
                selectColumn.append(",").append(fieldColumnMapper.getColumnName()).append(" ").append(fieldColumnMapper.getFieldName());
            }
            _logger.trace("Column " + columnCount + " , ColumnName : " + fieldColumnMapper.getColumnName() + " , FieldName : " + fieldColumnMapper.getFieldName());
        }
        return selectColumn.toString();
    }

    public String executePageResultsCount(T entity) {
        T pagination = entity;
        PageResultsSqlCache pageResultsSqlCache = (PageResultsSqlCache)JpaBaseService.pageResultsBoundSqlCache.getIfPresent((Object)((JpaPagination)pagination).getPageResultSelectUUID());
        String selectSql = pageResultsSqlCache.getSql().replaceAll("\r\n+", " \n").replaceAll("\n+", " \n").replaceAll("\t", " ").replaceAll(" +", " ");
        BoundSql boundSql = pageResultsSqlCache.getBoundSql();
        _logger.trace("Count original SQL  :\n" + selectSql);
        StringBuffer sql = new StringBuffer("select count(1) countrows_ ");
        StringBuffer countSql = new StringBuffer();
        if (boundSql.getParameterMappings() == null || boundSql.getParameterMappings().isEmpty()) {
            countSql.append(selectSql);
        } else {
            for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                countSql.append(selectSql.substring(0, selectSql.indexOf("?")));
                countSql.append("#{" + parameterMapping.getProperty() + "}");
                selectSql = selectSql.substring(selectSql.indexOf("?") + 1);
            }
            countSql.append(selectSql);
        }
        String countSqlLowerCase = countSql.toString().toLowerCase();
        _logger.trace("Count SQL LowerCase  :\n" + countSqlLowerCase);
        if (countSqlLowerCase.indexOf("distinct ") > 0 || countSqlLowerCase.indexOf(" group by ") > 0 || countSqlLowerCase.indexOf(" having ") > 0 || countSqlLowerCase.indexOf(" from ") != countSqlLowerCase.lastIndexOf(" from ")) {
            _logger.trace("Count SQL Complex ");
            sql.append("from").append(" (").append(countSql).append(" ) count_table_");
        } else {
            int fromIndex = countSqlLowerCase.indexOf(" from ");
            int orderByIndex = countSqlLowerCase.indexOf(" order by ");
            _logger.trace("Count SQL from Index " + fromIndex + " , order by " + orderByIndex);
            if (orderByIndex > -1) {
                sql.append(countSql.substring(fromIndex, orderByIndex));
            } else {
                sql.append(countSql.substring(fromIndex));
            }
        }
        JpaBaseService.pageResultsBoundSqlCache.invalidate((Object)((JpaPagination)pagination).getPageResultSelectUUID());
        _logger.trace("Count SQL : \n" + sql);
        return sql.toString();
    }
}

