/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles3;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.servlet.ServletApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class SpringWildcardServletTilesApplicationContext
extends ServletApplicationContext {
    protected ResourcePatternResolver resolver;

    public SpringWildcardServletTilesApplicationContext(ServletContext servletContext) {
        super(servletContext);
        this.resolver = new ServletContextResourcePatternResolver(servletContext);
    }

    public ApplicationResource getResource(String localePath) {
        ApplicationResource retValue = null;
        Collection<ApplicationResource> urlSet = this.getResources(localePath);
        if (urlSet != null && !urlSet.isEmpty()) {
            retValue = urlSet.iterator().next();
        }
        return retValue;
    }

    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        ApplicationResource retValue = null;
        Collection<ApplicationResource> urlSet = this.getResources(base.getLocalePath(locale));
        if (urlSet != null && !urlSet.isEmpty()) {
            retValue = urlSet.iterator().next();
        }
        return retValue;
    }

    public Collection<ApplicationResource> getResources(String path) {
        Resource[] resources;
        try {
            resources = this.resolver.getResources(path);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationResource> resourceList = new ArrayList<ApplicationResource>();
        if (resources != null && resources.length > 0) {
            for (int i = 0; i < resources.length; ++i) {
                try {
                    URL url = resources[i].getURL();
                    resourceList.add((ApplicationResource)new URLApplicationResource(url.toExternalForm(), url));
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("no URL for " + resources[i].toString(), e);
                }
            }
        }
        return resourceList;
    }
}

