/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.util.ReflectionUtils;

public abstract class MockMvcRequestBuilders {
    private MockMvcRequestBuilders() {
    }

    public static MockHttpServletRequestBuilder get(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder post(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder put(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder delete(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder options(String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, String urlTemplate, Object ... urlVariables) {
        return new MockHttpServletRequestBuilder(httpMethod, urlTemplate, urlVariables);
    }

    public static MockMultipartHttpServletRequestBuilder fileUpload(String urlTemplate, Object ... urlVariables) {
        return new MockMultipartHttpServletRequestBuilder(urlTemplate, urlVariables);
    }

    public static RequestBuilder asyncDispatch(final MvcResult mvcResult) {
        return new RequestBuilder(){

            @Override
            public MockHttpServletRequest buildRequest(ServletContext servletContext) {
                MockHttpServletRequest request = mvcResult.getRequest();
                Method method = ReflectionUtils.findMethod(request.getClass(), (String)"setAsyncStarted", (Class[])new Class[]{Boolean.TYPE});
                method.setAccessible(true);
                ReflectionUtils.invokeMethod((Method)method, (Object)request, (Object[])new Object[]{false});
                return request;
            }
        };
    }
}

