/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.springframework.cache.Cache;
import org.springframework.cache.jcache.JCacheCache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;

public class JCacheCacheManager
extends AbstractTransactionSupportingCacheManager {
    private CacheManager cacheManager;
    private boolean allowNullValues = true;

    public JCacheCacheManager() {
    }

    public JCacheCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setAllowNullValues(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public void afterPropertiesSet() {
        if (this.cacheManager == null) {
            this.cacheManager = Caching.getCachingProvider().getCacheManager();
        }
        super.afterPropertiesSet();
    }

    protected Collection<Cache> loadCaches() {
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>();
        for (String cacheName : this.cacheManager.getCacheNames()) {
            javax.cache.Cache jcache = this.cacheManager.getCache(cacheName);
            caches.add(new JCacheCache(jcache, this.allowNullValues));
        }
        return caches;
    }

    public Cache getCache(String name) {
        javax.cache.Cache jcache;
        Cache cache = super.getCache(name);
        if (cache == null && (jcache = this.cacheManager.getCache(name)) != null) {
            cache = new JCacheCache(jcache, this.allowNullValues);
            this.addCache(cache);
        }
        return cache;
    }
}

