/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.context.ConstructorConstraintMappingContext;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.cfg.context.TypeConstraintMappingContext;
import org.hibernate.validator.internal.cfg.DefaultConstraintMapping;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContextImplBase;
import org.hibernate.validator.internal.cfg.context.ExecutableConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.PropertyConstraintMappingContextImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public final class TypeConstraintMappingContextImpl<C>
extends ConstraintMappingContextImplBase
implements TypeConstraintMappingContext<C> {
    private static final Log log = LoggerFactory.make();
    private final Class<C> beanClass;
    private final Set<ExecutableConstraintMappingContextImpl> executableContexts = CollectionHelper.newHashSet();
    private final Set<PropertyConstraintMappingContextImpl> propertyContexts = CollectionHelper.newHashSet();
    private final Set<Member> configuredMembers = CollectionHelper.newHashSet();
    private List<Class<?>> defaultGroupSequence;
    private Class<? extends DefaultGroupSequenceProvider<? super C>> defaultGroupSequenceProviderClass;

    public TypeConstraintMappingContextImpl(DefaultConstraintMapping mapping, Class<C> beanClass) {
        super(mapping);
        this.beanClass = beanClass;
        mapping.getAnnotationProcessingOptions().ignoreAnnotationConstraintForClass(beanClass, Boolean.FALSE);
    }

    @Override
    public TypeConstraintMappingContext<C> constraint(ConstraintDef<?, ?> definition) {
        this.addConstraint(ConfiguredConstraint.forType(definition, this.beanClass));
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> ignoreAnnotations() {
        this.mapping.getAnnotationProcessingOptions().ignoreClassLevelConstraintAnnotations(this.beanClass, Boolean.TRUE);
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> ignoreAllAnnotations() {
        this.mapping.getAnnotationProcessingOptions().ignoreAnnotationConstraintForClass(this.beanClass, Boolean.TRUE);
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> defaultGroupSequence(Class<?> ... defaultGroupSequence) {
        this.defaultGroupSequence = Arrays.asList(defaultGroupSequence);
        return this;
    }

    @Override
    public TypeConstraintMappingContext<C> defaultGroupSequenceProviderClass(Class<? extends DefaultGroupSequenceProvider<? super C>> defaultGroupSequenceProviderClass) {
        this.defaultGroupSequenceProviderClass = defaultGroupSequenceProviderClass;
        return this;
    }

    @Override
    public PropertyConstraintMappingContext property(String property, ElementType elementType) {
        Contracts.assertNotNull(property, "The property name must not be null.");
        Contracts.assertNotNull((Object)elementType, "The element type must not be null.");
        Contracts.assertNotEmpty(property, Messages.MESSAGES.propertyNameMustNotBeEmpty());
        Member member = ReflectionHelper.getMember(this.beanClass, property, elementType);
        if (member == null || member.getDeclaringClass() != this.beanClass) {
            throw log.getUnableToFindPropertyWithAccessException(this.beanClass, property, elementType);
        }
        if (this.configuredMembers.contains(member)) {
            throw log.getPropertyHasAlreadyBeConfiguredViaProgrammaticApiException(this.beanClass.getName(), property);
        }
        PropertyConstraintMappingContextImpl context = new PropertyConstraintMappingContextImpl(this, member);
        this.configuredMembers.add(member);
        this.propertyContexts.add(context);
        return context;
    }

    @Override
    public MethodConstraintMappingContext method(String name, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(name, Messages.MESSAGES.methodNameMustNotBeNull());
        Method method = ReflectionHelper.getDeclaredMethod(this.beanClass, name, parameterTypes);
        if (method == null || method.getDeclaringClass() != this.beanClass) {
            throw log.getUnableToFindMethodException(this.beanClass, ExecutableElement.getExecutableAsString(name, parameterTypes));
        }
        if (this.configuredMembers.contains(method)) {
            throw log.getMethodHasAlreadyBeConfiguredViaProgrammaticApiException(this.beanClass.getName(), ExecutableElement.getExecutableAsString(name, parameterTypes));
        }
        ExecutableConstraintMappingContextImpl context = new ExecutableConstraintMappingContextImpl(this, method);
        this.configuredMembers.add(method);
        this.executableContexts.add(context);
        return context;
    }

    @Override
    public ConstructorConstraintMappingContext constructor(Class<?> ... parameterTypes) {
        Constructor<C> constructor = ReflectionHelper.getDeclaredConstructor(this.beanClass, parameterTypes);
        if (constructor == null || constructor.getDeclaringClass() != this.beanClass) {
            throw log.getBeanDoesNotContainConstructorException(this.beanClass.getName(), StringHelper.join(parameterTypes, ", "));
        }
        if (this.configuredMembers.contains(constructor)) {
            throw log.getConstructorHasAlreadyBeConfiguredViaProgrammaticApiException(this.beanClass.getName(), ExecutableElement.getExecutableAsString(this.beanClass.getSimpleName(), parameterTypes));
        }
        ExecutableConstraintMappingContextImpl context = new ExecutableConstraintMappingContextImpl(this, constructor);
        this.configuredMembers.add(constructor);
        this.executableContexts.add(context);
        return context;
    }

    public BeanConfiguration<C> build(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider) {
        return new BeanConfiguration<C>(ConfigurationSource.API, this.beanClass, this.buildConstraintElements(constraintHelper, parameterNameProvider), this.defaultGroupSequence, this.getDefaultGroupSequenceProvider());
    }

    private Set<ConstrainedElement> buildConstraintElements(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider) {
        HashSet<ConstrainedElement> elements = CollectionHelper.newHashSet();
        elements.add(new ConstrainedType(ConfigurationSource.API, ConstraintLocation.forClass(this.beanClass), this.getConstraints(constraintHelper)));
        for (ExecutableConstraintMappingContextImpl executableContext : this.executableContexts) {
            elements.add(executableContext.build(constraintHelper, parameterNameProvider));
        }
        for (PropertyConstraintMappingContextImpl propertyContext : this.propertyContexts) {
            elements.add(propertyContext.build(constraintHelper));
        }
        return elements;
    }

    private DefaultGroupSequenceProvider<? super C> getDefaultGroupSequenceProvider() {
        return this.defaultGroupSequenceProviderClass != null ? ReflectionHelper.newInstance(this.defaultGroupSequenceProviderClass, "default group sequence provider") : null;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    protected ConstraintDescriptorImpl.ConstraintType getConstraintType() {
        return ConstraintDescriptorImpl.ConstraintType.GENERIC;
    }
}

