/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.config.resilience;

import org.ehcache.core.internal.resilience.RobustLoaderWriterResilienceStrategy;
import org.ehcache.core.internal.resilience.RobustResilienceStrategy;
import org.ehcache.impl.config.resilience.DefaultResilienceStrategyConfiguration;
import org.ehcache.impl.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.resilience.ResilienceStrategyProvider;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class DefaultResilienceStrategyProviderConfiguration
extends ClassInstanceProviderConfiguration<String, ResilienceStrategy<?, ?>>
implements ServiceCreationConfiguration<ResilienceStrategyProvider> {
    private static final Class<? extends ResilienceStrategy> DEFAULT_RESILIENCE = RobustResilienceStrategy.class;
    private static final Class<? extends ResilienceStrategy> DEFAULT_LOADER_WRITER_RESILIENCE = RobustLoaderWriterResilienceStrategy.class;
    private DefaultResilienceStrategyConfiguration defaultRegularConfiguration = new DefaultResilienceStrategyConfiguration(DEFAULT_RESILIENCE, new Object[0]);
    private DefaultResilienceStrategyConfiguration defaultLoaderWriterConfiguration = new DefaultResilienceStrategyConfiguration(DEFAULT_LOADER_WRITER_RESILIENCE, new Object[0]);

    public DefaultResilienceStrategyConfiguration getDefaultConfiguration() {
        return this.defaultRegularConfiguration;
    }

    public DefaultResilienceStrategyConfiguration getDefaultLoaderWriterConfiguration() {
        return this.defaultLoaderWriterConfiguration;
    }

    @Override
    public Class<ResilienceStrategyProvider> getServiceType() {
        return ResilienceStrategyProvider.class;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultResilienceStrategy(Class<? extends ResilienceStrategy> clazz, Object ... arguments) {
        this.defaultRegularConfiguration = new DefaultResilienceStrategyConfiguration(clazz, arguments);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultResilienceStrategy(ResilienceStrategy<?, ?> resilienceStrategy) {
        this.defaultRegularConfiguration = new DefaultResilienceStrategyConfiguration(resilienceStrategy);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultLoaderWriterResilienceStrategy(Class<? extends ResilienceStrategy> clazz, Object ... arguments) {
        this.defaultLoaderWriterConfiguration = new DefaultResilienceStrategyConfiguration(clazz, arguments);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration setDefaultLoaderWriterResilienceStrategy(ResilienceStrategy<?, ?> resilienceStrategy) {
        this.defaultLoaderWriterConfiguration = new DefaultResilienceStrategyConfiguration(resilienceStrategy);
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration addResilienceStrategyFor(String alias, Class<? extends ResilienceStrategy> clazz, Object ... arguments) {
        this.getDefaults().put(alias, new DefaultResilienceStrategyConfiguration(clazz, arguments));
        return this;
    }

    public DefaultResilienceStrategyProviderConfiguration addResilienceStrategyFor(String alias, ResilienceStrategy<?, ?> resilienceStrategy) {
        this.getDefaults().put(alias, new DefaultResilienceStrategyConfiguration(resilienceStrategy));
        return this;
    }
}

