/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.EhcacheBase;
import org.ehcache.core.EhcacheRuntimeConfiguration;
import org.ehcache.core.Jsr107Cache;
import org.ehcache.core.StatusTransitioner;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.internal.util.CollectionUtil;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.ehcache.spi.loaderwriter.CacheWritingException;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;

public class EhcacheWithLoaderWriter<K, V>
extends EhcacheBase<K, V> {
    private static final Supplier<Boolean> SUPPLY_FALSE = () -> Boolean.FALSE;
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final boolean useLoaderInAtomics;

    public EhcacheWithLoaderWriter(CacheConfiguration<K, V> configuration, Store<K, V> store, ResilienceStrategy<K, V> resilienceStrategy, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, Logger logger) {
        this(configuration, store, resilienceStrategy, cacheLoaderWriter, eventDispatcher, true, logger);
    }

    EhcacheWithLoaderWriter(CacheConfiguration<K, V> runtimeConfiguration, Store<K, V> store, ResilienceStrategy<K, V> resilienceStrategy, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, boolean useLoaderInAtomics, Logger logger) {
        this(new EhcacheRuntimeConfiguration<K, V>(runtimeConfiguration), store, resilienceStrategy, cacheLoaderWriter, eventDispatcher, useLoaderInAtomics, logger, new StatusTransitioner(logger));
    }

    EhcacheWithLoaderWriter(EhcacheRuntimeConfiguration<K, V> runtimeConfiguration, Store<K, V> store, ResilienceStrategy<K, V> resilienceStrategy, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, boolean useLoaderInAtomics, Logger logger, StatusTransitioner statusTransitioner) {
        super(runtimeConfiguration, store, resilienceStrategy, eventDispatcher, logger, statusTransitioner);
        this.cacheLoaderWriter = Objects.requireNonNull(cacheLoaderWriter, "CacheLoaderWriter cannot be null");
        this.useLoaderInAtomics = useLoaderInAtomics;
    }

    @Override
    protected Store.ValueHolder<V> doGet(K key) throws StoreAccessException {
        Function<Object, Object> mappingFunction = k -> {
            try {
                return this.cacheLoaderWriter.load(k);
            }
            catch (Exception e) {
                throw new StorePassThroughException(ExceptionFactory.newCacheLoadingException(e));
            }
        };
        return this.store.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Store.PutStatus doPut(K key, V value) throws StoreAccessException {
        BiFunction<Object, Object, Object> remappingFunction = (key1, previousValue) -> {
            try {
                this.cacheLoaderWriter.write(key1, value);
            }
            catch (Exception e) {
                throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
            }
            return value;
        };
        this.store.compute(key, remappingFunction);
        return Store.PutStatus.PUT;
    }

    @Override
    protected boolean doRemoveInternal(K key) throws StoreAccessException {
        boolean[] modified = new boolean[]{false};
        BiFunction<Object, Object, Object> remappingFunction = (key1, previousValue) -> {
            modified[0] = previousValue != null;
            try {
                this.cacheLoaderWriter.delete(key1);
            }
            catch (Exception e) {
                throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
            }
            return null;
        };
        this.store.compute(key, remappingFunction);
        return modified[0];
    }

    @Override
    protected Map<K, V> doGetAllInternal(Set<? extends K> keys, boolean includeNulls) throws StoreAccessException {
        HashMap successes = new HashMap(1);
        HashMap failures = new HashMap(1);
        Function computeFunction = keys1 -> {
            Map loaded;
            try {
                loaded = this.cacheLoaderWriter.loadAll((Iterable<K>)keys1);
            }
            catch (BulkCacheLoadingException bcle) {
                loaded = Collections.emptyMap();
                this.collectSuccessesAndFailures(bcle, successes, failures);
            }
            catch (Exception e) {
                loaded = Collections.emptyMap();
                for (Object key : keys1) {
                    failures.put(key, e);
                }
            }
            int size = CollectionUtil.findBestCollectionSize(keys1, 1);
            LinkedHashMap computeResult = new LinkedHashMap(size);
            for (Object key : keys1) {
                computeResult.put(key, null);
            }
            if (!loaded.isEmpty()) {
                for (Object key : keys1) {
                    Object value = loaded.get(key);
                    successes.put(key, value);
                    computeResult.put(key, value);
                }
            }
            return computeResult.entrySet();
        };
        HashMap result = new HashMap();
        Map computedMap = this.store.bulkComputeIfAbsent(keys, computeFunction);
        int hits = 0;
        int keyCount = 0;
        for (Map.Entry entry : computedMap.entrySet()) {
            ++keyCount;
            if (entry.getValue() != null) {
                result.put(entry.getKey(), entry.getValue().get());
                ++hits;
                continue;
            }
            if (!includeNulls || !failures.isEmpty()) continue;
            result.put(entry.getKey(), null);
        }
        this.addBulkMethodEntriesCount(BulkOps.GET_ALL_HITS, hits);
        if (failures.isEmpty()) {
            this.addBulkMethodEntriesCount(BulkOps.GET_ALL_MISS, keyCount - hits);
            return result;
        }
        successes.putAll(result);
        throw new BulkCacheLoadingException(failures, successes);
    }

    @Override
    public void doPutAll(Map<? extends K, ? extends V> entries) throws BulkCacheWritingException, StoreAccessException {
        HashSet successes = new HashSet(1);
        HashMap failures = new HashMap(1);
        Map<? extends K, ? extends V> entriesToRemap = CollectionUtil.copyMapButFailOnNull(entries);
        int[] actualPutCount = new int[]{0};
        Function computeFunction = entries1 -> {
            this.cacheLoaderWriterWriteAllCall((Iterable<? extends Map.Entry<? extends K, ? extends V>>)entries1, entriesToRemap, successes, failures);
            int size = CollectionUtil.findBestCollectionSize(entries1, 1);
            LinkedHashMap mutations = new LinkedHashMap(size);
            for (Map.Entry entry : entries1) {
                Object newValue;
                Object existingValue;
                Object key = entry.getKey();
                if (this.newValueAlreadyExpired(key, existingValue = entry.getValue(), newValue = entriesToRemap.remove(key))) {
                    mutations.put(key, null);
                    continue;
                }
                if (successes.contains(key)) {
                    actualPutCount[0] = actualPutCount[0] + 1;
                    mutations.put(key, newValue);
                    continue;
                }
                mutations.put(key, existingValue);
            }
            return mutations.entrySet();
        };
        this.store.bulkCompute(entries.keySet(), computeFunction);
        this.addBulkMethodEntriesCount(BulkOps.PUT_ALL, actualPutCount[0]);
        if (!failures.isEmpty()) {
            throw new BulkCacheWritingException(failures, successes);
        }
    }

    private void cacheLoaderWriterWriteAllCall(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, V> entriesToRemap, Set<K> successes, Map<K, Exception> failures) throws IllegalStateException {
        block5: {
            HashMap<K, V> toWrite = new HashMap<K, V>();
            for (Map.Entry<K, V> entry : entries) {
                V value = entriesToRemap.get(entry.getKey());
                if (value == null) continue;
                toWrite.put(entry.getKey(), value);
            }
            try {
                if (toWrite.isEmpty()) break block5;
                this.cacheLoaderWriter.writeAll(toWrite.entrySet());
                successes.addAll(toWrite.keySet());
            }
            catch (BulkCacheWritingException bcwe) {
                EhcacheWithLoaderWriter.collectSuccessesAndFailures(bcwe, successes, failures);
            }
            catch (Exception e) {
                for (Object key : toWrite.keySet()) {
                    failures.put(key, e);
                }
            }
        }
    }

    private static <K> void collectSuccessesAndFailures(BulkCacheWritingException bcwe, Set<K> successes, Map<K, Exception> failures) {
        successes.addAll(bcwe.getSuccesses());
        failures.putAll(bcwe.getFailures());
    }

    private void collectSuccessesAndFailures(BulkCacheLoadingException bcle, Map<K, V> successes, Map<K, Exception> failures) {
        successes.putAll(bcle.getSuccesses());
        failures.putAll(bcle.getFailures());
    }

    @Override
    protected void doRemoveAll(Set<? extends K> keys) throws BulkCacheWritingException, StoreAccessException {
        HashSet successes = new HashSet(1);
        HashMap failures = new HashMap(1);
        HashMap<K, Object> entriesToRemove = new HashMap<K, Object>(keys.size());
        for (K key : keys) {
            entriesToRemove.put(key, null);
        }
        int[] actualRemoveCount = new int[]{0};
        Function removalFunction = entries -> {
            Set<K> unknowns = this.cacheLoaderWriterDeleteAllCall((Iterable<? extends Map.Entry<? extends K, ? extends V>>)entries, (Map<K, ? extends V>)entriesToRemove, successes, failures);
            int size = CollectionUtil.findBestCollectionSize(entries, 1);
            LinkedHashMap results = new LinkedHashMap(size);
            for (Map.Entry entry : entries) {
                Object key = entry.getKey();
                Object existingValue = entry.getValue();
                if (successes.contains(key)) {
                    if (existingValue != null) {
                        actualRemoveCount[0] = actualRemoveCount[0] + 1;
                    }
                    results.put(key, null);
                    entriesToRemove.remove(key);
                    continue;
                }
                if (unknowns.contains(key)) {
                    results.put(key, null);
                    continue;
                }
                results.put(key, existingValue);
            }
            return results.entrySet();
        };
        this.store.bulkCompute(keys, removalFunction);
        this.addBulkMethodEntriesCount(BulkOps.REMOVE_ALL, actualRemoveCount[0]);
        if (!failures.isEmpty()) {
            throw new BulkCacheWritingException(failures, successes);
        }
    }

    private Set<K> cacheLoaderWriterDeleteAllCall(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, ? extends V> entriesToRemove, Set<K> successes, Map<K, Exception> failures) {
        HashSet<K> unknowns = new HashSet<K>();
        HashSet<K> toDelete = new HashSet<K>();
        for (Map.Entry<K, V> entry : entries) {
            Object key = entry.getKey();
            if (!entriesToRemove.containsKey(key)) continue;
            toDelete.add(key);
        }
        try {
            this.cacheLoaderWriter.deleteAll(toDelete);
            successes.addAll(toDelete);
        }
        catch (BulkCacheWritingException bcwe) {
            EhcacheWithLoaderWriter.collectSuccessesAndFailures(bcwe, successes, failures);
        }
        catch (Exception e) {
            for (Object key : toDelete) {
                failures.put(key, e);
                unknowns.add(key);
            }
        }
        return unknowns;
    }

    @Override
    public Store.ValueHolder<V> doPutIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        Function<Object, Object> mappingFunction = k -> {
            if (this.useLoaderInAtomics) {
                try {
                    V loaded = this.cacheLoaderWriter.load(k);
                    if (loaded != null) {
                        return loaded;
                    }
                }
                catch (Exception e) {
                    throw new StorePassThroughException(ExceptionFactory.newCacheLoadingException(e));
                }
            }
            try {
                this.cacheLoaderWriter.write(k, value);
            }
            catch (Exception e) {
                throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
            }
            put.accept(true);
            return value;
        };
        return this.store.computeIfAbsent(key, mappingFunction);
    }

    @Override
    protected Store.RemoveStatus doRemove(K key, V value) throws StoreAccessException {
        boolean[] hitRemoved = new boolean[]{false, false};
        BiFunction<Object, Object, Object> remappingFunction = (k, inCache) -> {
            if ((inCache = this.loadFromLoaderWriter(key, inCache)) == null) {
                return null;
            }
            hitRemoved[0] = true;
            if (value.equals(inCache)) {
                try {
                    this.cacheLoaderWriter.delete(k);
                }
                catch (Exception e) {
                    throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                }
                hitRemoved[1] = true;
                return null;
            }
            return inCache;
        };
        this.store.compute(key, remappingFunction, SUPPLY_FALSE);
        if (hitRemoved[1]) {
            return Store.RemoveStatus.REMOVED;
        }
        if (hitRemoved[0]) {
            return Store.RemoveStatus.KEY_PRESENT;
        }
        return Store.RemoveStatus.KEY_MISSING;
    }

    @Override
    protected V doReplace(K key, V value) throws CacheLoadingException, CacheWritingException, StoreAccessException {
        Object[] old = new Object[1];
        BiFunction<Object, Object, Object> remappingFunction = (k, inCache) -> {
            if ((inCache = this.loadFromLoaderWriter(key, inCache)) == null) {
                return null;
            }
            try {
                this.cacheLoaderWriter.write(key, value);
            }
            catch (Exception e) {
                throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
            }
            old[0] = inCache;
            if (this.newValueAlreadyExpired(key, inCache, value)) {
                return null;
            }
            return value;
        };
        this.store.compute(key, remappingFunction);
        return (V)old[0];
    }

    private V loadFromLoaderWriter(K key, V inCache) {
        block5: {
            if (inCache == null) {
                if (this.useLoaderInAtomics) {
                    try {
                        inCache = this.cacheLoaderWriter.load(key);
                        if (inCache == null) {
                            return null;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        throw new StorePassThroughException(ExceptionFactory.newCacheLoadingException(e));
                    }
                }
                return null;
            }
        }
        return inCache;
    }

    @Override
    protected Store.ReplaceStatus doReplace(K key, V oldValue, V newValue) throws CacheLoadingException, CacheWritingException, StoreAccessException {
        boolean[] successHit = new boolean[]{false, false};
        BiFunction<Object, Object, Object> remappingFunction = (k, inCache) -> {
            if ((inCache = this.loadFromLoaderWriter(key, inCache)) == null) {
                return null;
            }
            successHit[1] = true;
            if (oldValue.equals(inCache)) {
                try {
                    this.cacheLoaderWriter.write(key, newValue);
                }
                catch (Exception e) {
                    throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                }
                successHit[0] = true;
                if (this.newValueAlreadyExpired(key, oldValue, newValue)) {
                    return null;
                }
                return newValue;
            }
            return inCache;
        };
        this.store.compute(key, remappingFunction, SUPPLY_FALSE);
        if (successHit[0]) {
            return Store.ReplaceStatus.HIT;
        }
        if (successHit[1]) {
            return Store.ReplaceStatus.MISS_PRESENT;
        }
        return Store.ReplaceStatus.MISS_NOT_PRESENT;
    }

    @Override
    public Jsr107Cache<K, V> createJsr107Cache() {
        return new Jsr107CacheImpl();
    }

    @Override
    public CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return this.cacheLoaderWriter;
    }

    private final class Jsr107CacheImpl
    extends EhcacheBase.Jsr107CacheBase {
        private Jsr107CacheImpl() {
        }

        @Override
        public void compute(K key, BiFunction<? super K, ? super V, ? extends V> computeFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter, Supplier<Boolean> withStatsAndEvents) {
            EhcacheWithLoaderWriter.this.putObserver.begin();
            EhcacheWithLoaderWriter.this.removeObserver.begin();
            EhcacheWithLoaderWriter.this.getObserver.begin();
            try {
                BiFunction<Object, Object, Object> fn = (mappedKey, mappedValue) -> {
                    if (mappedValue == null) {
                        EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                    } else {
                        EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                    }
                    Object newValue = computeFunction.apply((Object)mappedKey, (Object)mappedValue);
                    if (newValue == mappedValue && !((Boolean)replaceEqual.get()).booleanValue()) {
                        return mappedValue;
                    }
                    if (((Boolean)invokeWriter.get()).booleanValue()) {
                        try {
                            if (newValue != null) {
                                EhcacheWithLoaderWriter.this.cacheLoaderWriter.write(mappedKey, newValue);
                            } else {
                                EhcacheWithLoaderWriter.this.cacheLoaderWriter.delete(mappedKey);
                            }
                        }
                        catch (Exception e) {
                            throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                        }
                    }
                    if (EhcacheWithLoaderWriter.this.newValueAlreadyExpired(mappedKey, mappedValue, newValue)) {
                        return null;
                    }
                    if (((Boolean)withStatsAndEvents.get()).booleanValue()) {
                        if (newValue == null) {
                            EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
                        } else {
                            EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
                        }
                    }
                    return newValue;
                };
                EhcacheWithLoaderWriter.this.store.compute(key, fn, replaceEqual);
            }
            catch (StoreAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public V getAndRemove(K key) {
            EhcacheWithLoaderWriter.this.getObserver.begin();
            EhcacheWithLoaderWriter.this.removeObserver.begin();
            Object[] existingValue = new Object[1];
            try {
                EhcacheWithLoaderWriter.this.store.compute(key, (mappedKey, mappedValue) -> {
                    existingValue[0] = mappedValue;
                    try {
                        EhcacheWithLoaderWriter.this.cacheLoaderWriter.delete(mappedKey);
                    }
                    catch (Exception e) {
                        throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                    }
                    return null;
                });
            }
            catch (StoreAccessException e) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue[0];
            if (returnValue != null) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
            } else {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                EhcacheWithLoaderWriter.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.NOOP);
            }
            return returnValue;
        }

        @Override
        public V getAndPut(K key, V value) {
            EhcacheWithLoaderWriter.this.getObserver.begin();
            EhcacheWithLoaderWriter.this.putObserver.begin();
            Object[] existingValue = new Object[1];
            try {
                EhcacheWithLoaderWriter.this.store.compute(key, (mappedKey, mappedValue) -> {
                    existingValue[0] = mappedValue;
                    try {
                        EhcacheWithLoaderWriter.this.cacheLoaderWriter.write(mappedKey, value);
                    }
                    catch (Exception e) {
                        throw new StorePassThroughException(ExceptionFactory.newCacheWritingException(e));
                    }
                    if (EhcacheWithLoaderWriter.this.newValueAlreadyExpired(mappedKey, mappedValue, value)) {
                        return null;
                    }
                    return value;
                });
            }
            catch (StoreAccessException e) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue[0];
            if (returnValue != null) {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
            } else {
                EhcacheWithLoaderWriter.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
            }
            EhcacheWithLoaderWriter.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
            return returnValue;
        }
    }
}

