/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class DocumentOrderComparator
implements Comparator,
Serializable {
    static Object lock = new Object();
    static WeakHashMap docOrdinals = new WeakHashMap();
    static int lastDocOrdinal = 0;
    static final DocumentOrderComparator theInstance = new DocumentOrderComparator();

    static Node parent(Node n) {
        if (n.getNodeType() == 2) {
            return ((Attr)n).getOwnerElement();
        }
        return n.getParentNode();
    }

    static int depth(Node n) {
        int depth = -1;
        while (n != null) {
            n = DocumentOrderComparator.parent(n);
            ++depth;
        }
        return depth;
    }

    static Document document(Node n) {
        if (n.getNodeType() == 9) {
            return (Document)n;
        }
        return n.getOwnerDocument();
    }

    static int siblingOrdinal(Node n) {
        int i = 0;
        while ((n = n.getPreviousSibling()) != null) {
            ++i;
        }
        return i;
    }

    static int compareDocumentOrderSibling(Node a, Node b) {
        int bord;
        short atype = a.getNodeType();
        short btype = b.getNodeType();
        if (atype == 2 && btype != 2) {
            return -1;
        }
        if (atype != 2 && btype == 2) {
            return 1;
        }
        if (atype == 2) {
            return a.getNodeName().compareTo(b.getNodeName());
        }
        int aord = DocumentOrderComparator.siblingOrdinal(a);
        if (aord < (bord = DocumentOrderComparator.siblingOrdinal(b))) {
            return -1;
        }
        if (aord > bord) {
            return 1;
        }
        return 0;
    }

    static int compareDocumentOrderSameLevel(Node a, Node b) {
        Node bp;
        Node ap = DocumentOrderComparator.parent(a);
        if (ap == (bp = DocumentOrderComparator.parent(b))) {
            return DocumentOrderComparator.compareDocumentOrderSibling(a, b);
        }
        int r = DocumentOrderComparator.compareDocumentOrderSameLevel(ap, bp);
        if (r == 0) {
            return DocumentOrderComparator.compareDocumentOrderSibling(a, b);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int documentOrdinal(Document doc) {
        Object object = lock;
        synchronized (object) {
            Integer ord = (Integer)docOrdinals.get(doc);
            if (ord == null) {
                if (lastDocOrdinal == Integer.MAX_VALUE) {
                    Map.Entry e;
                    TreeMap tm = new TreeMap();
                    Iterator it = docOrdinals.entrySet().iterator();
                    while (it.hasNext()) {
                        e = it.next();
                        tm.put(e.getValue(), e.getKey());
                    }
                    lastDocOrdinal = 0;
                    docOrdinals.clear();
                    it = tm.entrySet().iterator();
                    while (it.hasNext()) {
                        e = it.next();
                        docOrdinals.put(e.getValue(), new Integer(++lastDocOrdinal));
                    }
                }
                docOrdinals.put(doc, new Integer(++lastDocOrdinal));
                return lastDocOrdinal;
            }
            return ord;
        }
    }

    public static int compareDocumentOrder(Node a, Node b) {
        int r;
        int bdepth;
        int adepth;
        Document bdoc;
        int depthcomp = 0;
        if (a == b) {
            return 0;
        }
        if (DocumentOrderComparator.parent(a) == DocumentOrderComparator.parent(b)) {
            return DocumentOrderComparator.compareDocumentOrderSibling(a, b);
        }
        Document adoc = DocumentOrderComparator.document(a);
        if (adoc != (bdoc = DocumentOrderComparator.document(b))) {
            int bord;
            int aord = DocumentOrderComparator.documentOrdinal(adoc);
            if (aord < (bord = DocumentOrderComparator.documentOrdinal(bdoc))) {
                return -1;
            }
            if (aord > bord) {
                return 1;
            }
        }
        if ((adepth = DocumentOrderComparator.depth(a)) < (bdepth = DocumentOrderComparator.depth(b))) {
            depthcomp = -1;
            while (adepth < bdepth) {
                b = DocumentOrderComparator.parent(b);
                --bdepth;
            }
        } else if (adepth > bdepth) {
            depthcomp = 1;
            while (adepth > bdepth) {
                a = DocumentOrderComparator.parent(a);
                --adepth;
            }
        }
        if ((r = DocumentOrderComparator.compareDocumentOrderSameLevel(a, b)) == 0) {
            r = depthcomp;
        }
        return r;
    }

    public int compare(Object o1, Object o2) {
        Node n1 = (Node)o1;
        Node n2 = (Node)o2;
        return DocumentOrderComparator.compareDocumentOrder(n1, n2);
    }

    public boolean equals(Object obj) {
        return obj instanceof DocumentOrderComparator;
    }

    DocumentOrderComparator() {
    }

    public static DocumentOrderComparator getInstance() {
        return theInstance;
    }
}

