/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import org.apache.tsik.xpath.util.NodeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Coerce {
    private static DecimalFormat dfInteger;
    private static DecimalFormat dfReal;

    private Coerce() {
    }

    public static Boolean toBoolean(Object arg) {
        if (arg == null) {
            return Boolean.FALSE;
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg;
        }
        if (arg instanceof Number) {
            double x = ((Number)arg).doubleValue();
            return new Boolean(!Double.isNaN(x) && x != 0.0);
        }
        if (arg instanceof NodeSet) {
            NodeSet x = (NodeSet)arg;
            return new Boolean(x.size() > 0);
        }
        if (arg instanceof String) {
            String x = (String)arg;
            return new Boolean(x.length() > 0);
        }
        return Boolean.TRUE;
    }

    private static int[] getNodePath(Node node, int depth) {
        Node parent = node.getParentNode();
        int[] path = parent == null ? new int[depth] : Coerce.getNodePath(parent, depth + 1);
        int pos = 0;
        while (node != null) {
            ++pos;
            node = node.getPreviousSibling();
        }
        path[path.length - depth] = pos;
        return path;
    }

    public static int[] getNodePath(Node node) {
        return Coerce.getNodePath(node, 1);
    }

    private static int compareNodePaths(int[] a, int[] b) {
        for (int i = 0; i < a.length && i < b.length; ++i) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (a[i] <= b[i]) continue;
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (a.length > b.length) {
            return 1;
        }
        return 0;
    }

    public static Node getFirstNodeDocumentOrder(NodeList nl) {
        int l = nl.getLength();
        if (l == 0) {
            return null;
        }
        if (l == 1) {
            return nl.item(0);
        }
        Node curnode = nl.item(0);
        int[] curpath = Coerce.getNodePath(curnode);
        for (int i = 1; i < l; ++i) {
            Node newnode = nl.item(i);
            int[] newpath = Coerce.getNodePath(newnode);
            if (Coerce.compareNodePaths(curpath, newpath) >= 0) continue;
            curnode = newnode;
            curpath = newpath;
        }
        return curnode;
    }

    private static void collectText(Node node, StringBuffer sb) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                sb.append(node.getNodeValue());
                break;
            }
            default: {
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    Coerce.collectText(node, sb);
                }
            }
        }
    }

    public static String stringValueOfNode(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                StringBuffer sb = new StringBuffer();
                Coerce.collectText(node, sb);
                return sb.toString();
            }
        }
        return node.getNodeValue();
    }

    public static String toString(Object arg) {
        if (arg == null) {
            return "";
        }
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Number) {
            double x = ((Number)arg).doubleValue();
            if (Double.isNaN(x)) {
                return "NaN";
            }
            if (x == 0.0) {
                return "0";
            }
            if (x == Double.POSITIVE_INFINITY) {
                return "Infinity";
            }
            if (x == Double.NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            StringBuffer sb = new StringBuffer();
            DecimalFormat df = x == Math.rint(x) ? dfInteger : dfReal;
            return df.format(x);
        }
        if (arg instanceof Boolean) {
            if (((Boolean)arg).booleanValue()) {
                return "true";
            }
            return "false";
        }
        if (arg instanceof NodeSet) {
            NodeSet ns = (NodeSet)arg;
            if (ns.size() > 0) {
                return Coerce.stringValueOfNode((Node)ns.iterator().next());
            }
            return "";
        }
        if (arg instanceof NodeList) {
            NodeList nl = (NodeList)arg;
            if (nl.getLength() > 0) {
                return Coerce.stringValueOfNode(nl.item(0));
            }
            return "";
        }
        return arg.toString();
    }

    public static Number toNumber(Object arg) {
        if (arg instanceof Number) {
            return (Number)arg;
        }
        if (arg instanceof Boolean) {
            if (((Boolean)arg).booleanValue()) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (arg instanceof String) {
            try {
                return dfReal.parse((String)arg);
            }
            catch (ParseException ex) {
                return new Double(Double.NaN);
            }
        }
        return Coerce.toNumber(Coerce.toString(arg));
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dfs.setMinusSign('-');
        dfs.setZeroDigit('0');
        dfInteger = new DecimalFormat("0;-0", dfs);
        dfReal = new DecimalFormat("0.0;-0.0", dfs);
    }
}

