/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlsig.SigningKey;
import org.apache.tsik.xmlsig.VerifyingKey;
import org.apache.tsik.xmlsig.elements.KeyInfo;
import org.apache.tsik.xmlsig.elements.ObjectElement;
import org.apache.tsik.xmlsig.elements.Reference;
import org.apache.tsik.xmlsig.elements.SignatureMethod;
import org.apache.tsik.xmlsig.elements.SignatureValue;
import org.apache.tsik.xmlsig.elements.SignedInfo;

public class Signature
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$elements$Signature == null ? (class$org$apache$tsik$xmlsig$elements$Signature = Signature.class$("org.apache.tsik.xmlsig.elements.Signature")) : class$org$apache$tsik$xmlsig$elements$Signature);
    public static final String name = "Signature";
    public static final String prefix = Namespaces.XMLSIG.getPrefix();
    public static final String uri = Namespaces.XMLSIG.getUri();
    public static final String[] ns = new String[]{prefix, uri};
    private SignedInfo signedInfo;
    private SignatureValue signatureValue;
    private KeyInfo keyInfo = null;
    private Vector objectElementVector = null;
    private SigningKey signingKey = null;
    private VerifyingKey verifyingKey = null;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$elements$Signature;

    public Signature() {
        this.signedInfo = new SignedInfo();
        this.signatureValue = new SignatureValue();
        this.keyInfo = new KeyInfo();
    }

    private Signature(SignedInfo si, SignatureValue sv, KeyInfo ki) {
        this.signedInfo = si;
        this.signatureValue = sv;
        this.keyInfo = ki;
    }

    public static Signature fromXml(DOMCursor cursor) throws ElementException {
        DOMCursor cc = Signature.placeCursor(cursor, name, prefix, uri, ns);
        SignedInfo si = SignedInfo.fromXml(cc);
        SignatureValue sv = SignatureValue.fromXml(cc);
        KeyInfo ki = KeyInfo.fromXml(cc);
        Vector<ObjectElement> v = new Vector<ObjectElement>();
        while (cc.moveToSibling(ObjectElement.uri, ObjectElement.name)) {
            ObjectElement o = ObjectElement.fromXml(cc);
            v.add(o);
        }
        Signature signature = new Signature(si, sv, ki);
        if (v.size() > 0) {
            signature.addObjects(v);
        }
        return signature;
    }

    public void addObjectsFromReferences(Vector v) {
        if (v.size() > 0) {
            this.objectElementVector = new Vector();
        }
        Enumeration enumer = v.elements();
        while (enumer.hasMoreElements()) {
            Reference r = (Reference)enumer.nextElement();
            this.objectElementVector.add(r.getObjectElement());
        }
    }

    public void addObjects(Vector v) {
        this.objectElementVector = v;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public SigningKey getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(SigningKey signingKey) {
        this.signingKey = signingKey;
        SignatureMethod sm = new SignatureMethod(signingKey.getAlgorithmUri());
        this.signedInfo.setSignatureMethod(sm);
    }

    public void setVerifyingKey(VerifyingKey verifyingKey) {
        this.verifyingKey = verifyingKey;
    }

    public void setSignatureValue(byte[] bsig) {
        this.signatureValue.setValue(bsig);
    }

    public boolean verifySignature(byte[] canon) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] sigValue = this.signatureValue.getValue();
        boolean verifies = this.verifyingKey.verifySignature(canon, sigValue);
        if (!verifies) {
            log.info("Signature value does not verify");
        }
        return verifies;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        this.signedInfo.toXml(wc);
        this.signatureValue.toXml(wc);
        if (this.keyInfo != null) {
            this.keyInfo.toXml(wc);
        }
        if (this.objectElementVector != null) {
            Enumeration enumer = this.objectElementVector.elements();
            while (enumer.hasMoreElements()) {
                ObjectElement o = (ObjectElement)enumer.nextElement();
                o.toXml(wc);
            }
        }
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = Signature.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            log.debug(e.toString());
            return false;
        }
    }

    public String toString() {
        String s = "[Signature" + this.signedInfo + this.signatureValue;
        if (this.keyInfo != null) {
            s = s + this.keyInfo;
        }
        if (this.objectElementVector != null) {
            Enumeration enumer = this.objectElementVector.elements();
            while (enumer.hasMoreElements()) {
                s = s + enumer.nextElement();
            }
        }
        s = s + "]";
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

