/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc.elements;

import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlenc.elements.CipherReference;
import org.apache.tsik.xmlenc.elements.CipherValue;

public class CipherData
extends ElementImpl {
    private static String name = "CipherData";
    private static String prefix = Namespaces.XMLENC.getPrefix();
    private static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private CipherValue encryptedValue;
    private CipherValue decryptedValue;
    private CipherReference cipherReference;

    public CipherData() {
        this.encryptedValue = new CipherValue();
        this.decryptedValue = new CipherValue();
        this.cipherReference = new CipherReference();
    }

    private CipherData(CipherValue encryptedValue, CipherReference cipherReference) {
        this.encryptedValue = encryptedValue;
        this.decryptedValue = new CipherValue();
        this.cipherReference = cipherReference;
    }

    public void setEncryptedValue(String base64) {
        this.encryptedValue.setValue(base64);
    }

    public String getEncryptedValue() {
        return this.encryptedValue.getValue();
    }

    public void setDecryptedValue(String val) {
        this.decryptedValue.setValue(val);
    }

    public String getDecryptedValue() {
        return this.decryptedValue.getValue();
    }

    public static CipherData fromXml(DOMCursor cursor) {
        DOMCursor cc = cursor.cloneCursor();
        cc.moveToChild(uri, name);
        CipherValue cipherValue = CipherValue.fromXml(cc);
        CipherReference cipherReference = CipherReference.fromXml(cc);
        return new CipherData(cipherValue, cipherReference);
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        this.encryptedValue.toXml(wc);
    }
}

