/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlenc;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementException;
import org.apache.tsik.xmlenc.elements.EncryptedData;
import org.apache.tsik.xmlenc.elements.EncryptedKey;
import org.apache.tsik.xmlenc.tools.ConversionException;
import org.apache.tsik.xmlenc.tools.Converter;
import org.apache.tsik.xmlsig.KeyInfo;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathException;
import org.w3c.dom.Document;

public class Decryptor {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlenc$Decryptor == null ? (class$org$apache$tsik$xmlenc$Decryptor = Decryptor.class$("org.apache.tsik.xmlenc.Decryptor")) : class$org$apache$tsik$xmlenc$Decryptor);
    private DOMCursor cursor;
    private Key decryptionKey;
    private XPath xpath;
    private EncryptedData encryptedData;
    private EncryptedKey encryptedKey;
    private KeyInfo keyInfo;
    static /* synthetic */ Class class$org$apache$tsik$xmlenc$Decryptor;

    public Decryptor(Document doc, Key decryptionKey, XPath xpath) throws IllegalArgumentException, NoSuchAlgorithmException {
        this.cursor = new DOMWriteCursor(doc);
        this.decryptionKey = decryptionKey;
        this.xpath = xpath;
    }

    public Decryptor(Document doc, XPath xpath) throws IllegalArgumentException, NoSuchAlgorithmException {
        this(doc, null, xpath);
    }

    public void setDecryptionKey(Key decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    public KeyInfo getKeyInfo() throws IllegalArgumentException, XPathException {
        if (this.keyInfo == null) {
            try {
                this.loadEncryptedData();
                EncryptedKey ekey = this.encryptedData.getEncryptedKey();
                this.keyInfo = ekey != null ? ekey.getKeyInfo() : this.encryptedData.getKeyInfo();
            }
            catch (IllegalArgumentException e) {
                this.loadEncryptedKey();
                this.keyInfo = this.encryptedData.getKeyInfo();
            }
        }
        return this.keyInfo;
    }

    public Document decrypt() throws IllegalArgumentException, NoSuchAlgorithmException, XPathException {
        return this.decrypt(false);
    }

    public Key decryptKey() throws IllegalArgumentException, NoSuchAlgorithmException, XPathException {
        if (this.decryptionKey == null) {
            throw new IllegalArgumentException("Decryption key is not set");
        }
        this.loadEncryptedKey();
        this.encryptedKey.setDecryptionKey(this.decryptionKey);
        this.encryptedKey.decrypt();
        return this.encryptedKey.getDecryptedKey();
    }

    public void decryptInPlace() throws IllegalArgumentException, NoSuchAlgorithmException, XPathException {
        this.decrypt(true);
    }

    private Document decrypt(boolean inPlace) throws IllegalArgumentException, XPathException, NoSuchAlgorithmException {
        try {
            return this.internalDecrypt(inPlace, false);
        }
        catch (XPathException e) {
            try {
                return this.internalDecrypt(inPlace, true);
            }
            catch (Throwable discard) {
                throw e;
            }
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return this.internalDecrypt(inPlace, true);
            }
            catch (Throwable discard) {
                throw e;
            }
        }
        catch (RuntimeException e) {
            try {
                return this.internalDecrypt(inPlace, true);
            }
            catch (Throwable discard) {
                throw e;
            }
        }
    }

    private Document internalDecrypt(boolean inPlace, boolean useOldDecrypt) throws IllegalArgumentException, XPathException, NoSuchAlgorithmException {
        DOMWriteCursor wc;
        Key key;
        if (this.decryptionKey == null) {
            throw new IllegalArgumentException("Decryption key is not set");
        }
        this.loadEncryptedData();
        EncryptedKey ekey = this.encryptedData.getEncryptedKey();
        if (ekey != null) {
            ekey.setDecryptionKey(this.decryptionKey);
            ekey.decrypt();
            key = ekey.getDecryptedKey();
        } else {
            key = this.decryptionKey;
        }
        this.encryptedData.setKey(key);
        this.encryptedData.decrypt(useOldDecrypt);
        if (inPlace) {
            wc = new DOMWriteCursor(this.cursor.getDocument());
        } else {
            wc = new DOMWriteCursor();
            this.cursor.moveToTop();
            wc.copyUnder(this.cursor);
        }
        wc.moveToXPath(this.xpath);
        String decryptedData = this.encryptedData.getDecryptedData();
        try {
            if (this.encryptedData.isContentType()) {
                Converter.stringToXmlContent(decryptedData, wc);
            } else {
                Converter.stringToXmlElement(decryptedData, wc);
            }
            return wc.getDocument();
        }
        catch (ConversionException e) {
            log.info(e);
            log.debug("decryptedData=" + decryptedData);
            throw new IllegalArgumentException(e.toString() + " (most likely the decryption key is incorrect)");
        }
    }

    private void loadEncryptedData() throws IllegalArgumentException, XPathException {
        if (this.encryptedData == null) {
            if (!this.cursor.moveToXPath(this.xpath)) {
                throw new XPathException("XPath expression '" + this.xpath.getXPath() + "'" + " evaluates to nothing");
            }
            try {
                this.encryptedData = EncryptedData.fromXml(this.cursor);
            }
            catch (ElementException e) {
                throw new IllegalArgumentException(e.toString());
            }
            if (this.encryptedData.isContentType()) {
                DOMCursor dataPos = this.cursor.cloneCursor();
                if (dataPos.moveToSibling(1) || dataPos.moveToSibling(-1)) {
                    throw new IllegalArgumentException("EncryptedData with #Content Type must not have siblings");
                }
                if (!dataPos.moveToParent()) {
                    throw new IllegalArgumentException("EncryptedData with #Content Type must not be the document element");
                }
            }
        }
    }

    private void loadEncryptedKey() throws IllegalArgumentException, XPathException {
        if (this.encryptedKey == null) {
            if (!this.cursor.moveToXPath(this.xpath)) {
                throw new XPathException("XPath expression '" + this.xpath.getXPath() + "'" + " evaluates to nothing");
            }
            try {
                this.encryptedKey = EncryptedKey.fromXmlStatic(this.cursor);
            }
            catch (ElementException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

