/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.elements;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.common.SchemaMapper;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.plugins.SoapMessage;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wss.Id;
import org.apache.tsik.wss.TokenResolver;
import org.apache.tsik.wss.elements.BinarySecurityToken;
import org.apache.tsik.wss.elements.EncryptedData;
import org.apache.tsik.wss.elements.EncryptedKey;
import org.apache.tsik.wss.elements.KeyInfo;
import org.apache.tsik.wss.elements.ReferenceList;
import org.apache.tsik.wss.elements.SecurityToken;
import org.apache.tsik.wss.elements.SecurityTokenReference;
import org.apache.tsik.wss.elements.Signature;
import org.apache.tsik.wss.elements.Timestamp;
import org.apache.tsik.wss.elements.UsernameToken;
import org.apache.tsik.xmlenc.AlgorithmType;
import org.apache.tsik.xmlenc.Encryptor;
import org.apache.tsik.xmlenc.tools.ConversionException;
import org.apache.tsik.xmlsig.Verifier;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathException;

public class Security
extends ElementImpl {
    private Element[] elements;
    private static Class c = class$org$apache$tsik$wss$elements$Security == null ? (class$org$apache$tsik$wss$elements$Security = Security.class$("org.apache.tsik.wss.elements.Security")) : class$org$apache$tsik$wss$elements$Security;
    private static Logger log = LoggerFactory.getLogger(c);
    public static String elementName = SchemaMapper.getName(c);
    public static String prefix = SchemaMapper.getPrefix(c);
    public static String uri = SchemaMapper.getUri(c);
    private static String[] ns = new String[]{prefix, uri};
    private boolean mustUnderstand;
    private XPath[] refs;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$Security;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$SecurityToken;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$EncryptedData;

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, elementName);
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].isVisible()) continue;
            ElementImpl ei = this.elements[i].getElementImpl();
            DOMWriteCursor c = new DOMWriteCursor();
            ei.toXml(c);
            String id = this.elements[i].getId();
            if (id != null) {
                Id.insertInto(c, id);
            }
            wc.copyUnder(c);
        }
    }

    public SecurityToken[] getSecurityTokens() {
        List l = this.getElementsOfType(class$org$apache$tsik$wss$elements$SecurityToken == null ? (class$org$apache$tsik$wss$elements$SecurityToken = Security.class$("org.apache.tsik.wss.elements.SecurityToken")) : class$org$apache$tsik$wss$elements$SecurityToken);
        SecurityToken[] st = new SecurityToken[l.size()];
        l.toArray(st);
        return st;
    }

    public EncryptedData[] getEncryptedDatas() {
        List l = this.getElementsOfType(class$org$apache$tsik$wss$elements$EncryptedData == null ? (class$org$apache$tsik$wss$elements$EncryptedData = Security.class$("org.apache.tsik.wss.elements.EncryptedData")) : class$org$apache$tsik$wss$elements$EncryptedData);
        EncryptedData[] ed = new EncryptedData[l.size()];
        l.toArray(ed);
        return ed;
    }

    private List getElementsOfType(Class c) {
        ArrayList<ElementImpl> l = new ArrayList<ElementImpl>();
        for (int i = 0; i < this.elements.length; ++i) {
            ElementImpl ei = this.elements[i].getElementImpl();
            if (!c.isInstance(ei)) continue;
            l.add(ei);
        }
        return l;
    }

    public ElementImpl getElement(String id) {
        for (int i = 0; i < this.elements.length; ++i) {
            String s = this.elements[i].getId();
            if (s == null || !s.equals(id)) continue;
            return this.elements[i].getElementImpl();
        }
        return null;
    }

    public Security() {
        this(null);
    }

    public Security(ArrayList elementList) {
        this.elements = elementList != null ? elementList.toArray(new Element[0]) : new Element[0];
    }

    private void addElem(Element element) {
        List<Element> list = Arrays.asList(this.elements);
        ArrayList<Element> al = new ArrayList<Element>(list);
        al.add(element);
        this.elements = al.toArray(new Element[0]);
    }

    public void addElement(String id, ElementImpl ei, DOMCursor c) {
        Element elem = new Element(id, ei, c);
        this.addElem(elem);
    }

    public void addHiddenElement(String id, ElementImpl ei, DOMCursor c) {
        Element elem = new Element(id, ei, c);
        elem.setVisible(false);
        this.addElem(elem);
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public static Security fromXml(DOMCursor cursor) {
        return Security.fromXmlMustUnderstand(false, cursor);
    }

    public static Security fromXmlMustUnderstand(boolean mustUnderstand, DOMCursor cursor) {
        DOMCursor c = Security.placeCursor(cursor, elementName, prefix, uri, ns);
        ArrayList<Element> elementList = new ArrayList<Element>();
        boolean more = c.moveToChild(1);
        while (more) {
            String id = Id.getId(c);
            ElementImpl ei = null;
            if (c.atElement(UsernameToken.uri, UsernameToken.elementName)) {
                ei = UsernameToken.fromXml(c);
            } else if (c.atElement(BinarySecurityToken.uri, BinarySecurityToken.elementName)) {
                try {
                    ei = BinarySecurityToken.fromXml(c);
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                }
            } else if (c.atElement(Timestamp.uri, Timestamp.elementName)) {
                ei = Timestamp.fromXml(c);
            } else if (c.atElement(Namespaces.XMLENC.getUri(), "EncryptedKey")) {
                ei = EncryptedKey.fromXml(c);
            } else if (c.atElement(Namespaces.XMLSIG.getUri(), "KeyInfo")) {
                ei = KeyInfo.fromXml(c);
            } else if (c.atElement(Namespaces.XMLENC.getUri(), "ReferenceList")) {
                ei = ReferenceList.fromXml(c);
            } else if (c.atElement(Namespaces.XMLENC.getUri(), "EncryptedData")) {
                ei = EncryptedData.fromXml(c);
            } else if (c.atElement(Namespaces.XMLSIG.getUri(), "Signature")) {
                ei = Signature.fromXml(c);
            } else {
                String s = "Security header cannot process " + c.getLocalName();
                if (mustUnderstand) {
                    throw new IllegalArgumentException(s);
                }
                log.warn(s);
            }
            Element e = new Element(id, ei, c);
            elementList.add(e);
            more = c.moveToSibling(1);
        }
        Security s = new Security(elementList);
        s.setMustUnderstand(mustUnderstand);
        return s;
    }

    public String toString() {
        String s = "[Security ";
        s = s + "mustUnderstand=" + this.mustUnderstand + " ";
        for (int i = 0; i < this.elements.length; ++i) {
            s = s + "element=" + this.elements[i];
        }
        return s + "]";
    }

    public EncryptedData encryptData(EncryptedKey ek, String refId, DOMCursor c, boolean encryptContent) throws NoSuchAlgorithmException {
        log.debug("About to encrypt");
        String uri = ek.getReferenceList().getDataReference();
        if (!uri.startsWith("#")) {
            throw new IllegalArgumentException("external references not supported: " + uri);
        }
        if (!("#" + refId).equals(uri)) {
            throw new IllegalArgumentException(uri + " not used by " + ek);
        }
        Encryptor e = new Encryptor(c.getDocument(), ek.getDekKey(), AlgorithmType.TRIPLEDES);
        if (encryptContent) {
            e.setContentEncryption(true);
        }
        DOMWriteCursor encDataCursor = new DOMWriteCursor(e.encrypt());
        EncryptedData ed = EncryptedData.fromXml(encDataCursor);
        ed.setId(refId);
        return ed;
    }

    public void process(SoapMessage soap, TokenResolver resolver) throws NoSuchAlgorithmException, XPathException, InvalidKeyException, SignatureException, ConversionException {
        log.debug("This Security header has " + this.elements.length + " sub elements");
        log.debug("Mustunderstand=" + this.mustUnderstand);
        log.debug("Processing security header");
        this.process(resolver, soap);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].hasBeenProcessed()) continue;
            log.debug("Missed processing sub element " + i);
        }
        log.debug("Done Processing security header");
    }

    private DOMWriteCursor getInSoapBody(String refId, SoapMessage soapMessage) {
        DOMWriteCursor bodyCursor = new DOMWriteCursor(soapMessage.getBody());
        if (bodyCursor.moveToXPath(XPath.fromXPointer(refId))) {
            return bodyCursor;
        }
        return null;
    }

    public void setRequiredSignatureReferences(XPath[] refs) {
        if (refs == null) {
            refs = new XPath[]{};
        }
        this.refs = refs;
    }

    private void process(TokenResolver resolver, SoapMessage soap) throws NoSuchAlgorithmException, XPathException, InvalidKeyException, SignatureException, ConversionException {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].hasBeenProcessed()) {
                log.warn("Sub element " + i + " has already been processed");
                continue;
            }
            ElementImpl ei = this.elements[i].getElementImpl();
            String id = this.elements[i].getId();
            log.debug("Sub element " + i + " has id=" + id);
            if (ei instanceof EncryptedKey) {
                DOMWriteCursor wc;
                log.debug("Sub element " + i + "=EncryptedKey");
                EncryptedKey ek = (EncryptedKey)ei;
                log.debug("ek=" + ek);
                ek.decrypt(resolver);
                ReferenceList refList = ek.getReferenceList();
                String refId = refList.getDataReference();
                log.debug("Decrypted key decrypts id " + refId);
                if (refId == null) {
                    String s = "No reference ID in EncryptedKey";
                    throw new IllegalArgumentException(s);
                }
                if (refId != null) {
                    resolver.map(refId, ek.getDekKey());
                }
                if ((wc = this.getInSoapBody(refId, soap)) != null) {
                    log.debug("Id found in SOAP body");
                    EncryptedData ed = EncryptedData.fromXml(wc);
                    ed.decryptInPlace(wc, resolver);
                } else {
                    log.debug("Id not found in SOAP body. Hold process.");
                }
                this.elements[i].setHasBeenProcessed();
                continue;
            }
            if (ei instanceof EncryptedData) {
                log.debug("Sub element " + i + "=EncryptedData");
                EncryptedData ed = (EncryptedData)ei;
                ed.decrypt(resolver);
                DOMCursor c = ed.getDecryptedData();
                SecurityToken st = this.convertToSecurityToken(c);
                if (st != null) {
                    log.debug("Decrypted a security token=" + st);
                    this.elements[i] = new Element(null, st, null);
                }
                this.elements[i].setHasBeenProcessed();
                continue;
            }
            if (ei instanceof BinarySecurityToken) {
                log.debug("Sub element " + i + "=BinarySecurityToken");
                BinarySecurityToken bst = (BinarySecurityToken)ei;
                if (bst.hasCertificate()) {
                    X509Certificate cert = bst.getCertificate();
                    log.debug("Mapping " + id + " to " + cert.getSubjectDN());
                    resolver.map(id, cert);
                } else if (bst.hasSki()) {
                    byte[] ski = bst.getSki();
                    log.debug("Mapping " + id + " to SKI of " + Base64.encode(ski));
                    resolver.map(id, ski);
                }
                this.elements[i].setHasBeenProcessed();
                continue;
            }
            if (ei instanceof Signature) {
                log.debug("Sub element " + i + "=Signature");
                Signature sig = (Signature)ei;
                log.debug("This signature is " + sig);
                KeyInfo ki = sig.getKeyInfo();
                SecurityTokenReference str = ki.getSecurityTokenReference();
                X509Certificate cert = resolver.resolveCert(str);
                if (cert == null) {
                    String s = "Cannot find certificate for " + str;
                    s = s + "map is " + resolver;
                    throw new SignatureException(s);
                }
                PublicKey key = cert.getPublicKey();
                XPath sigLoc = this.elements[i].getDOMCursor().createXPath();
                Verifier verifier = new Verifier(soap.getDocument(), sigLoc);
                boolean isVerified = verifier.verify(key);
                log.debug("Signature is " + isVerified);
                if (!isVerified) {
                    throw new SignatureException("Signature " + sig + " does not verify");
                }
                for (int j = 0; j < this.refs.length; ++j) {
                    if (verifier.isReferenced(this.refs[j])) continue;
                    String s = "Required reference " + this.refs[j] + " not " + "referenced in ignature " + sig;
                    throw new SignatureException(s);
                }
                this.elements[i].setHasBeenProcessed();
                continue;
            }
            if (ei instanceof Timestamp) {
                log.debug("Sub element " + i + "=Timestamp");
                Timestamp timestamp = (Timestamp)ei;
                this.elements[i].setHasBeenProcessed();
                continue;
            }
            String s = "Security content not handled: " + ei;
            if (this.mustUnderstand) {
                throw new IllegalArgumentException(s);
            }
            log.warn(s);
        }
    }

    private SecurityToken convertToSecurityToken(DOMCursor c) {
        if (c.atElement(UsernameToken.uri, UsernameToken.elementName)) {
            return UsernameToken.fromXml(c);
        }
        if (c.atElement(BinarySecurityToken.uri, BinarySecurityToken.elementName)) {
            try {
                return BinarySecurityToken.fromXml(c);
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Element {
        private boolean hasBeenProcessed = false;
        private String id;
        private ElementImpl element;
        private DOMCursor cursor;
        private boolean isVisible = true;

        Element(String id, ElementImpl element, DOMCursor cursor) {
            this.id = id;
            this.element = element;
            if (cursor != null) {
                this.cursor = cursor.cloneCursor();
            }
        }

        void setHasBeenProcessed() {
            this.hasBeenProcessed = true;
        }

        boolean hasBeenProcessed() {
            return this.hasBeenProcessed;
        }

        String getId() {
            return this.id;
        }

        ElementImpl getElementImpl() {
            return this.element;
        }

        DOMCursor getDOMCursor() {
            return this.cursor;
        }

        void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        boolean isVisible() {
            return this.isVisible;
        }

        public String toString() {
            String s = "[Element ";
            s = s + " visible=" + this.isVisible;
            s = s + " processed=" + this.hasBeenProcessed;
            s = s + " id=" + this.id;
            s = s + " element=" + this.element;
            s = this.cursor != null ? s + " cursor=" + this.cursor.createXPath().toString() : s + " cursor=[result of WSS processing]";
            return s + "]";
        }
    }
}

