/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.elements;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.tsik.common.SchemaMapper;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.wss.Base64EncoderDecoder;
import org.apache.tsik.wss.EncoderDecoder;
import org.apache.tsik.wss.Id;

public class KeyIdentifier
extends ElementImpl {
    private static Class c = class$org$apache$tsik$wss$elements$KeyIdentifier == null ? (class$org$apache$tsik$wss$elements$KeyIdentifier = KeyIdentifier.class$("org.apache.tsik.wss.elements.KeyIdentifier")) : class$org$apache$tsik$wss$elements$KeyIdentifier;
    static String elementName = SchemaMapper.getName(c);
    static String prefix = SchemaMapper.getPrefix(c);
    static String uri = SchemaMapper.getUri(c);
    private static String[] ns = new String[]{prefix, uri};
    private static String x509TokenProfileFragmentUri = SchemaMapper.get("$x509-token-profile-fragment-uri");
    private static String wssFragmentUri = SchemaMapper.get("$wss-fragment-uri");
    private static String v3IdString = "X509v3";
    private static String skiIdString = "X509SubjectKeyIdentifier";
    private EncoderDecoder encDec;
    private String id;
    private X509Certificate cert;
    private byte[] ski;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$KeyIdentifier;

    public KeyIdentifier(X509Certificate cert) {
        this.cert = cert;
        this.encDec = new Base64EncoderDecoder();
    }

    public KeyIdentifier(byte[] ski) {
        this.ski = ski;
        this.encDec = new Base64EncoderDecoder();
    }

    public boolean hasSki() {
        return this.ski != null;
    }

    public boolean hasCertificate() {
        return this.cert != null;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public byte[] getSki() {
        return this.ski;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, elementName);
        if (this.id != null) {
            Id.insertInto(wc, this.id);
        }
        if (this.hasCertificate()) {
            wc.setAttribute("ValueType", x509TokenProfileFragmentUri + "#" + v3IdString);
        }
        if (this.hasSki()) {
            wc.setAttribute("ValueType", x509TokenProfileFragmentUri + "#" + skiIdString);
        }
        wc.setAttribute("EncodingType", wssFragmentUri + "#" + this.encDec.getAttributeValue());
        String enc = null;
        try {
            if (this.hasCertificate()) {
                enc = this.encDec.encode(this.cert.getEncoded());
            } else if (this.hasSki()) {
                enc = this.encDec.encode(this.ski);
            }
        }
        catch (CertificateEncodingException e) {
            enc = e.toString();
        }
        wc.setText(enc);
    }

    public static KeyIdentifier fromXml(DOMCursor cursor) throws CertificateException {
        String valueType;
        DOMCursor c = KeyIdentifier.placeCursor(cursor, elementName, prefix, uri, ns);
        String id = c.getAttribute(Id.uri, Id.attributeName);
        X509Certificate cert = null;
        String encodingType = c.getAttribute("EncodingType");
        Base64EncoderDecoder encDec = null;
        if (encodingType != null) {
            if (encodingType.equals(wssFragmentUri + "#Base64Binary")) {
                encDec = new Base64EncoderDecoder();
            } else {
                throw new IllegalArgumentException("encoding type unknown:" + encodingType);
            }
        }
        if (encDec == null) {
            encDec = new Base64EncoderDecoder();
        }
        if ((valueType = c.getAttribute("ValueType")) == null) {
            throw new IllegalArgumentException("default value type unknown");
        }
        if (valueType.equals(x509TokenProfileFragmentUri + "#" + v3IdString)) {
            byte[] b = encDec.decode(c.getText());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(b);
            cert = (X509Certificate)cf.generateCertificate(bais);
            KeyIdentifier ki = new KeyIdentifier(cert);
            ki.setId(id);
            return ki;
        }
        if (valueType.equals(x509TokenProfileFragmentUri + "#" + skiIdString)) {
            byte[] ski = encDec.decode(c.getText());
            KeyIdentifier ki = new KeyIdentifier(ski);
            ki.setId(id);
            return ki;
        }
        throw new IllegalArgumentException("value type unknown:" + valueType);
    }

    public String toString() {
        String s = "[KeyIdentifier ";
        s = s + " encodingType=" + wssFragmentUri + "#" + this.encDec.getAttributeValue();
        if (this.id != null) {
            s = s + " id=" + this.id;
        }
        if (this.cert != null) {
            s = s + " valueType=" + x509TokenProfileFragmentUri + "#" + v3IdString;
            try {
                s = s + " cert=" + this.encDec.encode(this.cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                s = s + e.toString();
            }
        }
        if (this.ski != null) {
            s = s + " valueType=" + x509TokenProfileFragmentUri + "#" + skiIdString;
            s = s + " ski=" + this.encDec.encode(this.ski);
        }
        return s + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

