/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.tsik.resource.XMLResource;
import org.apache.tsik.resource.XSLResource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class TrAXXSLResource
implements XSLResource {
    TransformerFactory tf;
    XMLResource xmlres;

    public TrAXXSLResource(XMLResource xmlres) {
        this.xmlres = xmlres;
        this.tf = TransformerFactory.newInstance();
    }

    public XSLResource.Stylesheet compile(Document xsl) throws SAXException {
        try {
            return new TrAXTemplates(this.tf.newTemplates(new DOMSource(xsl)));
        }
        catch (TransformerConfigurationException tcx) {
            throw new SAXException(tcx);
        }
    }

    public Document process(Document xml, XSLResource.Stylesheet xsl) throws SAXException {
        ErrorListenerImpl el = new ErrorListenerImpl();
        try {
            TrAXTemplates tt = (TrAXTemplates)xsl;
            Templates tmpl = tt.templates;
            Transformer xform = tmpl.newTransformer();
            DOMResult res = new DOMResult(this.xmlres.createDocument());
            xform.setErrorListener(el);
            xform.transform(new DOMSource(xml), res);
            return (Document)res.getNode();
        }
        catch (TransformerException tx) {
            List l = el.getErrors();
            if (l.isEmpty()) {
                throw new SAXException(tx);
            }
            Iterator it = el.getErrors().iterator();
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                TransformerException ex = (TransformerException)it.next();
                sb.append(ex.getMessage());
                sb.append('\n');
            }
            sb.deleteCharAt(sb.length() - 1);
            throw new SAXException(sb.toString(), tx);
        }
    }

    public Document process(Document xml, Document xsl) throws IOException {
        try {
            return this.process(xml, this.compile(xsl));
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    static class TrAXTemplates
    implements XSLResource.Stylesheet {
        Templates templates;

        TrAXTemplates(Templates templates) {
            this.templates = templates;
        }
    }

    private static class ErrorListenerImpl
    implements ErrorListener {
        List exList = new ArrayList();

        private ErrorListenerImpl() {
        }

        public void error(TransformerException ex) throws TransformerException {
            this.exList.add(ex);
            throw ex;
        }

        public void warning(TransformerException ex) throws TransformerException {
            this.exList.add(ex);
        }

        public void fatalError(TransformerException ex) throws TransformerException {
            this.exList.add(ex);
            throw ex;
        }

        public List getErrors() {
            return this.exList;
        }
    }
}

