/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.resource;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.tsik.uuid.UUID;
import org.apache.tsik.xpath.IDDiscriminator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMOperations {
    private static final String NS_XML = "http://www.w3.org/XML/1998/namespace";
    private static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final DOMOperations defaultInstance = new DOMOperations();
    private boolean isDom20Only;
    private static TimeZone tzUTC = TimeZone.getTimeZone("UTC");
    private static DateFormat dfISOZ = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSS'Z'");

    public static DOMOperations getInstance() {
        return defaultInstance;
    }

    public DOMOperations() {
    }

    public DOMOperations(Node exampleNode) {
        this.isDom20Only = this.hasDom20Feature(exampleNode);
    }

    public DOMImplementation implementation(Node node) {
        Document doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        return doc != null ? doc.getImplementation() : null;
    }

    private boolean hasDom20Feature(Node n) {
        if (this.isDom20Only) {
            return true;
        }
        DOMImplementation impl = this.implementation(n);
        if (impl != null) {
            return impl.hasFeature("Core", "2.0");
        }
        try {
            Class.forName("org.apache.crimson.jaxp.DocumentBuilderImpl");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Element firstElementChild(Node p) {
        for (Node n = p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Element nextElementSibling(Node s) {
        for (Node n = s.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Element lastElementChild(Node p) {
        for (Node n = p.getLastChild(); n != null; n = n.getPreviousSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Element previousElementSibling(Node s) {
        for (Node n = s.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Node parent(Node n) {
        if (n == null) {
            throw new IllegalArgumentException("n is null");
        }
        if (n.getNodeType() == 2) {
            if (this.hasDom20Feature(n)) {
                return ((Attr)n).getOwnerElement();
            }
            throw new IllegalArgumentException("parent(Attr) not supported on DOM level 1");
        }
        return n.getParentNode();
    }

    public int depth(Node n) {
        int depth = -1;
        while (n != null) {
            n = this.parent(n);
            ++depth;
        }
        return depth;
    }

    public Document document(Node n) {
        if (n.getNodeType() == 9) {
            return (Document)n;
        }
        return n.getOwnerDocument();
    }

    public String getLocalName(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return name;
        }
        return name.substring(colonPos + 1, name.length());
    }

    public String getLocalName(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name;
                if (this.hasDom20Feature(n) && (name = n.getLocalName()) != null) {
                    return name;
                }
                return this.getLocalName(n.getNodeName());
            }
        }
        return null;
    }

    public String getPrefix(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return name.substring(0, colonPos);
    }

    public String getPrefix(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                if (this.hasDom20Feature(n) && n.getLocalName() != null) {
                    return n.getPrefix();
                }
                return this.getPrefix(n.getNodeName());
            }
        }
        return null;
    }

    public String resolvePrefix(String prefix, Node n, boolean useDefault) {
        if (!useDefault && prefix == null) {
            return null;
        }
        if ("xml".equals(prefix)) {
            return NS_XML;
        }
        if ("xmlns".equals(prefix)) {
            return NS_XMLNS;
        }
        while (n != null) {
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                Attr a = prefix == null ? e.getAttributeNode("xmlns") : e.getAttributeNode("xmlns:" + prefix);
                if (a != null) {
                    String x = a.getValue();
                    if ("".equals(x)) {
                        return null;
                    }
                    return x;
                }
            }
            n = this.parent(n);
        }
        return null;
    }

    public String reverseResolvePrefix(String namespaceURI, Node n) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI is null");
        }
        if (n == null) {
            throw new IllegalArgumentException("n is null");
        }
        if (NS_XML.equals(namespaceURI)) {
            return "xml";
        }
        if (NS_XMLNS.equals(namespaceURI)) {
            return "xmlns";
        }
        while (n != null) {
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                NamedNodeMap nm = e.getAttributes();
                for (int i = 0; i < nm.getLength(); ++i) {
                    Attr a = (Attr)nm.item(i);
                    String aname = a.getNodeName();
                    if (!aname.startsWith("xmlns:") || !a.getNodeValue().equals(namespaceURI)) continue;
                    return aname.substring(6);
                }
            }
            n = this.parent(n);
        }
        return null;
    }

    public String getNamespaceURI(Node n) {
        short nodeType = n.getNodeType();
        if (nodeType != 1 && nodeType != 2) {
            return null;
        }
        if (this.hasDom20Feature(n) && n.getLocalName() != null) {
            String name;
            if (nodeType == 2 && this.getPrefix(n) == null && !(name = n.getNodeName()).equals("xmlns") && !name.startsWith("xmlns:")) {
                return null;
            }
            return n.getNamespaceURI();
        }
        String name = n.getNodeName();
        if (nodeType == 2 && (name.equals("xmlns") || name.startsWith("xmlns:"))) {
            return NS_XMLNS;
        }
        String prefix = this.getPrefix(name);
        return this.resolvePrefix(prefix, n, nodeType == 1);
    }

    public boolean matchName(Node n, String namespaceURI, String localName) {
        String nln = this.getLocalName(n);
        if (!(nln != null ? nln.equals(localName) : localName == null)) {
            return false;
        }
        String nns = this.getNamespaceURI(n);
        return nns != null ? nns.equals(namespaceURI) : namespaceURI == null;
    }

    public String getNodePath(Node n) {
        switch (n.getNodeType()) {
            case 9: {
                return "";
            }
            case 11: {
                return "#fragment";
            }
            case -1: {
                return "#no-parent";
            }
            case 2: {
                return this.getNodePath(this.parent(n)) + "/@" + n.getNodeName();
            }
            case 1: {
                return this.getNodePath(n.getParentNode()) + "/" + n.getNodeName();
            }
            case 3: 
            case 4: {
                return this.getNodePath(n.getParentNode()) + "/text()";
            }
            case 8: {
                return this.getNodePath(n.getParentNode()) + "/comment()";
            }
        }
        throw new IllegalArgumentException();
    }

    private void collectText(Node node, StringBuffer sb) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                sb.append(node.getNodeValue());
                break;
            }
            default: {
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.collectText(node, sb);
                }
            }
        }
    }

    public String stringValueOfNode(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                StringBuffer sb = new StringBuffer();
                this.collectText(node, sb);
                return sb.toString();
            }
        }
        return node.getNodeValue();
    }

    public String replaceWhiteSpace(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer(s.length());
        block3: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    sb.append(' ');
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public String collapseWhiteSpace(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer sb = new StringBuffer(s.length());
        boolean gotSpace = true;
        block3: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (gotSpace) continue block3;
                    sb.append(' ');
                    gotSpace = true;
                    continue block3;
                }
                default: {
                    gotSpace = false;
                    sb.append(ch);
                }
            }
        }
        if (gotSpace && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public Element createElementNS(Document doc, String namespaceURI, String qualifiedName) {
        if (this.hasDom20Feature(doc)) {
            return doc.createElementNS(namespaceURI, qualifiedName);
        }
        return doc.createElement(qualifiedName);
    }

    public void setAttributeNS(Element elt, String namespaceURI, String qualifiedName, String value) {
        if (this.hasDom20Feature(elt)) {
            elt.setAttributeNS(namespaceURI, qualifiedName, value);
        } else {
            elt.setAttribute(qualifiedName, value);
        }
    }

    public void removeAttributeNS(Element e, String namespaceURI, String localName) {
        if (this.hasDom20Feature(e)) {
            e.removeAttributeNS(namespaceURI, localName);
        } else {
            e.removeAttribute(localName);
        }
    }

    public Attr getAttributeNodeNS(Element e, String namespaceURI, String localName) {
        if (this.hasDom20Feature(e)) {
            return e.getAttributeNodeNS(namespaceURI, localName);
        }
        return e.getAttributeNode(localName);
    }

    public void setNamespace(Element elt, String prefix, String namespaceURI) {
        String qname;
        if (elt == null) {
            throw new IllegalArgumentException("elt is null");
        }
        if ("".equals(prefix)) {
            throw new IllegalArgumentException("prefix is the empty string");
        }
        if ("".equals(namespaceURI)) {
            throw new IllegalArgumentException("namespaceURI is the empty string");
        }
        if (prefix != null && namespaceURI == null) {
            throw new IllegalArgumentException("cannot undeclare a prefix");
        }
        if ("xmlns".equals(prefix)) {
            throw new IllegalArgumentException("cannot remap prefix xmlns");
        }
        if ("xml".equals(prefix) && !NS_XML.equals(namespaceURI)) {
            throw new IllegalArgumentException("cannot remap prefix xml");
        }
        String string = qname = prefix == null ? "xmlns" : "xmlns:" + prefix;
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        this.setAttributeNS(elt, NS_XMLNS, qname, namespaceURI);
    }

    public Element appendElementByExpandedName(Node parent, String namespaceURI, String desiredPrefix, String localName) {
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        if ("".equals(desiredPrefix)) {
            throw new IllegalArgumentException("desiredPrefix is the empty string");
        }
        if ("xmlns".equals(desiredPrefix)) {
            throw new IllegalArgumentException("element prefix is xmlns");
        }
        String chosenPrefix = null;
        boolean createNamespaceNode = false;
        String current = this.resolvePrefix(desiredPrefix, parent, true);
        if (current == null ? namespaceURI == null : current.equals(namespaceURI)) {
            chosenPrefix = desiredPrefix;
            createNamespaceNode = false;
        } else if (namespaceURI == null) {
            chosenPrefix = null;
            createNamespaceNode = true;
        } else {
            chosenPrefix = this.reverseResolvePrefix(namespaceURI, parent);
            if (chosenPrefix != null) {
                createNamespaceNode = false;
            } else {
                createNamespaceNode = true;
                if (desiredPrefix == null) {
                    desiredPrefix = "ns";
                }
                if (this.resolvePrefix(desiredPrefix, parent, false) == null) {
                    chosenPrefix = desiredPrefix;
                } else {
                    int i = 0;
                    while (this.resolvePrefix(chosenPrefix = desiredPrefix + i, parent, false) != null) {
                        ++i;
                    }
                }
            }
        }
        String qname = chosenPrefix == null ? localName : chosenPrefix + ":" + localName;
        Element elt = this.createElementNS(this.document(parent), namespaceURI, qname);
        if (createNamespaceNode) {
            this.setNamespace(elt, chosenPrefix, namespaceURI);
        }
        parent.appendChild(elt);
        return elt;
    }

    public void setAttributeByExpandedName(Element owner, String namespaceURI, String desiredPrefix, String localName, String value) {
        if (owner == null) {
            throw new IllegalArgumentException("owner is null");
        }
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        if ("xmlns".equals(desiredPrefix)) {
            throw new IllegalArgumentException("desiredPrefix is xmlns");
        }
        if ("".equals(desiredPrefix)) {
            throw new IllegalArgumentException("desiredPrefix is the empty string");
        }
        if ("xmlns".equals(localName)) {
            throw new IllegalArgumentException("localName is xmlns");
        }
        String chosenPrefix = null;
        boolean createNamespaceNode = false;
        if (namespaceURI == null) {
            chosenPrefix = null;
            createNamespaceNode = false;
        } else {
            String current = this.resolvePrefix(desiredPrefix, owner, false);
            if (namespaceURI.equals(current)) {
                chosenPrefix = desiredPrefix;
                createNamespaceNode = false;
            } else {
                chosenPrefix = this.reverseResolvePrefix(namespaceURI, owner);
                if (chosenPrefix != null) {
                    createNamespaceNode = false;
                } else {
                    createNamespaceNode = true;
                    if (desiredPrefix == null) {
                        desiredPrefix = "ns";
                    }
                    if (this.resolvePrefix(desiredPrefix, owner, false) == null) {
                        chosenPrefix = desiredPrefix;
                    } else {
                        int i = 0;
                        while (this.resolvePrefix(chosenPrefix = desiredPrefix + i, owner, false) != null) {
                            ++i;
                        }
                    }
                }
            }
        }
        String qname = chosenPrefix == null ? localName : chosenPrefix + ":" + localName;
        this.setAttributeNS(owner, namespaceURI, qname, value);
        if (createNamespaceNode) {
            this.setNamespace(owner, chosenPrefix, namespaceURI);
        }
    }

    public Element createElementByExpandedName(Document doc, String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName is null");
        }
        String autoPrefix = "jh" + UUID.generate().toString().substring(3, 7);
        String qname = autoPrefix + ":" + localName;
        Element elt = this.createElementNS(doc, namespaceURI, qname);
        this.setNamespace(elt, autoPrefix, namespaceURI);
        return elt;
    }

    public Map getInScopeNamespaces(Element src) {
        HashMap<String, String> m = new HashMap<String, String>();
        while (src != null) {
            NamedNodeMap nm = src.getAttributes();
            for (int i = 0; i < nm.getLength(); ++i) {
                String prefix;
                Attr attr = (Attr)nm.item(i);
                String name = attr.getNodeName();
                if (!name.startsWith("xmlns")) continue;
                if (name.length() == 5) {
                    prefix = null;
                } else {
                    if (name.charAt(5) != ':') continue;
                    prefix = name.substring(6);
                }
                if (m.containsKey(prefix)) continue;
                m.put(prefix, attr.getNodeValue());
            }
            Node parent = src.getParentNode();
            if (parent.getNodeType() == 1) {
                src = (Element)parent;
                continue;
            }
            src = null;
        }
        if (!m.containsKey(null)) {
            m.put(null, "");
        }
        return m;
    }

    public void transferInScopeNamespaces(Element dest, Element src) {
        Map srcNamespaces = this.getInScopeNamespaces(src);
        this.transferNamespaces(dest, srcNamespaces);
    }

    public void transferNamespaces(Element dest, Map srcNamespaces) {
        Map<Object, String> destNamespaces;
        Node destParent = dest.getParentNode();
        if (destParent.getNodeType() == 1) {
            destNamespaces = this.getInScopeNamespaces((Element)destParent);
        } else {
            destNamespaces = new HashMap();
            destNamespaces.put(null, "");
        }
        Iterator it = srcNamespaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            String attrName = key == null ? "xmlns" : "xmlns:" + key;
            String srcValue = (String)e.getValue();
            String destValue = (String)destNamespaces.get(key);
            dest.removeAttribute(attrName);
            if (destValue != null && srcValue.equals(destValue)) continue;
            if (srcValue.length() == 0) {
                srcValue = null;
            }
            this.setNamespace(dest, key, srcValue);
        }
    }

    public Element graft(Node dest, Element src) {
        Document doc = this.document(dest);
        Element copy = (Element)doc.importNode(src, true);
        dest.appendChild(copy);
        this.transferInScopeNamespaces(copy, src);
        return copy;
    }

    public void graftChildren(Node dest, Node srcParent) {
        Document doc = this.document(dest);
        for (Node src = srcParent.getFirstChild(); src != null; src = src.getNextSibling()) {
            if (src.getNodeType() == 1) {
                this.graft(dest, (Element)src);
                continue;
            }
            Node copy = doc.importNode(src, true);
            dest.appendChild(copy);
        }
    }

    public void transplant(Node dest, Element src) {
        Node srcParent = src.getParentNode();
        if (srcParent.getNodeType() != 1) {
            throw new IllegalArgumentException("can't move the top element");
        }
        Map srcNamespaces = this.getInScopeNamespaces(src);
        srcParent.removeChild(src);
        dest.appendChild(src);
        this.transferNamespaces(src, srcNamespaces);
    }

    public void removeAllChildren(Node parent) {
        Node n;
        while ((n = parent.getLastChild()) != null) {
            parent.removeChild(n);
        }
    }

    public Element findID(Document doc, String id, IDDiscriminator resolver) {
        Element elem = doc.getDocumentElement();
        if (elem == null) {
            return null;
        }
        return this.findID(elem, id, resolver);
    }

    private Element findID(Element elem, String id, IDDiscriminator resolver) {
        NamedNodeMap attrs = elem.getAttributes();
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                String name = this.getLocalName(attr);
                String uri = this.getNamespaceURI(attr);
                if (!resolver.isIDAttribute(elem, uri, name) || !id.equals(attr.getNodeValue())) continue;
                return elem;
            }
        }
        elem = this.firstElementChild(elem);
        while (elem != null) {
            Element found = this.findID(elem, id, resolver);
            if (found != null) {
                return found;
            }
            elem = this.nextElementSibling(elem);
        }
        return null;
    }

    public String formatISODate(Date date) {
        return dfISOZ.format(date);
    }

    public String formatISODate(long date) {
        return this.formatISODate(new Date(date));
    }

    public Date parseISODate(String date) {
        try {
            return dfISOZ.parse(date);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    static {
        dfISOZ.setTimeZone(tzUTC);
    }
}

