/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.services;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.maxkey.client.oauth.exceptions.OAuthSignatureException;
import org.maxkey.client.oauth.services.Base64Encoder;
import org.maxkey.client.oauth.services.SignatureService;
import org.maxkey.client.utils.HttpEncoder;
import org.maxkey.client.utils.Preconditions;

public class HMACSha1SignatureService
implements SignatureService {
    private static final String EMPTY_STRING = "";
    private static final String CARRIAGE_RETURN = "\r\n";
    private static final String UTF8 = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String METHOD = "HMAC-SHA1";

    @Override
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(baseString, "Base string cant be null or empty string");
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return this.doSign(baseString, String.valueOf(HttpEncoder.encode(apiSecret)) + '&' + HttpEncoder.encode(tokenSecret));
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    private String doSign(String toSign, String keyString) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(UTF8), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] bytes = mac.doFinal(toSign.getBytes(UTF8));
        return this.bytesToBase64String(bytes).replace(CARRIAGE_RETURN, EMPTY_STRING);
    }

    private String bytesToBase64String(byte[] bytes) {
        return Base64Encoder.getInstance().encode(bytes);
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

