/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.builder.api;

import com.connsec.client.http.HttpVerb;
import com.connsec.client.oauth.builder.api.DefaultApi20;
import com.connsec.client.oauth.extractors.AccessTokenExtractor;
import com.connsec.client.oauth.extractors.GsonJsonTokenExtractor;
import com.connsec.client.oauth.model.OAuthConfig;

public class ConnsecPasswordApi20
extends DefaultApi20 {
    private String accessTokenUrl;
    private String grantType = "password";
    private String scope = "&scope=%s";
    private String accessTokenMethod = "POST";
    private static final String AUTHORIZE_PARAM = "&client_id=%s&client_secret=%s&username=%s&password=%s";

    public ConnsecPasswordApi20(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public HttpVerb getAccessTokenVerb() {
        if (this.accessTokenMethod != null && this.accessTokenMethod.toUpperCase().equals("POST")) {
            return HttpVerb.POST;
        }
        return HttpVerb.GET;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new GsonJsonTokenExtractor();
    }

    public String getAccessTokenEndpoint() {
        if (this.accessTokenUrl.indexOf("?") > 0) {
            return this.accessTokenUrl + "&grant_type=" + this.grantType + AUTHORIZE_PARAM;
        }
        return this.accessTokenUrl + "?grant_type=" + this.grantType + AUTHORIZE_PARAM;
    }

    public String getAuthorizationUrl(OAuthConfig config, String username, String password) {
        return String.format(this.getAccessTokenEndpoint(), config.getApiKey(), config.getApiSecret(), username, password);
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String toString() {
        return "OAuthApi20 [accessTokenUrl=" + this.accessTokenUrl + ", grantType=" + this.grantType + ", scope=" + this.scope + "]";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        return "";
    }

    public String getGrantType() {
        return "authorization_code";
    }
}

