/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.jose;

import com.google.common.base.Strings;
import com.nimbusds.jose.EncryptionMethod;
import javax.persistence.Basic;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class JWEEncryptionMethodEmbed {
    public static final JWEEncryptionMethodEmbed NONE = JWEEncryptionMethodEmbed.getForAlgorithmName("none");
    private EncryptionMethod algorithm;

    public JWEEncryptionMethodEmbed() {
    }

    public JWEEncryptionMethodEmbed(EncryptionMethod algorithm) {
        this.algorithm = algorithm;
    }

    public static JWEEncryptionMethodEmbed getForAlgorithmName(String algorithmName) {
        JWEEncryptionMethodEmbed ent = new JWEEncryptionMethodEmbed();
        ent.setAlgorithmName(algorithmName);
        if (ent.getAlgorithm() == null) {
            return null;
        }
        return ent;
    }

    @Basic
    public String getAlgorithmName() {
        if (this.algorithm != null) {
            return this.algorithm.getName();
        }
        return null;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithm = !Strings.isNullOrEmpty((String)algorithmName) ? EncryptionMethod.parse((String)algorithmName) : null;
    }

    public String toString() {
        return "JWEEncryptionMethodEmbed [algorithm=" + this.algorithm + "]";
    }

    @Transient
    public EncryptionMethod getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(EncryptionMethod algorithm) {
        this.algorithm = algorithm;
    }
}

