/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.client.oauth.builder;

import com.connsec.client.http.SignatureType;
import com.connsec.client.oauth.builder.api.Api;
import com.connsec.client.oauth.exceptions.OAuthException;
import com.connsec.client.oauth.model.OAuthConfig;
import com.connsec.client.oauth.oauth.OAuthService;
import com.connsec.client.utils.Preconditions;
import java.io.OutputStream;

public class ServiceBuilder {
    private String apiKey;
    private String apiSecret;
    private String callback = "oob";
    private Api api;
    private String scope;
    private SignatureType signatureType = SignatureType.Header;
    private OutputStream debugStream = null;

    public ServiceBuilder provider(Class<? extends Api> apiClass) {
        this.api = this.createApi(apiClass);
        return this;
    }

    private Api createApi(Class<? extends Api> apiClass) {
        Api api;
        Preconditions.checkNotNull(apiClass, (String)"Api class cannot be null");
        try {
            api = apiClass.newInstance();
        }
        catch (Exception e) {
            throw new OAuthException("Error while creating the Api object", e);
        }
        return api;
    }

    public ServiceBuilder provider(Api api) {
        Preconditions.checkNotNull((Object)api, (String)"Api cannot be null");
        this.api = api;
        return this;
    }

    public ServiceBuilder callback(String callback) {
        Preconditions.checkNotNull((Object)callback, (String)"Callback can't be null");
        this.callback = callback;
        return this;
    }

    public ServiceBuilder apiKey(String apiKey) {
        Preconditions.checkEmptyString((String)apiKey, (String)"Invalid Api key");
        this.apiKey = apiKey;
        return this;
    }

    public ServiceBuilder apiSecret(String apiSecret) {
        Preconditions.checkEmptyString((String)apiSecret, (String)"Invalid Api secret");
        this.apiSecret = apiSecret;
        return this;
    }

    public ServiceBuilder scope(String scope) {
        Preconditions.checkEmptyString((String)scope, (String)"Invalid OAuth scope");
        this.scope = scope;
        return this;
    }

    public ServiceBuilder signatureType(SignatureType type) {
        Preconditions.checkNotNull((Object)type, (String)"Signature type can't be null");
        this.signatureType = type;
        return this;
    }

    public ServiceBuilder debugStream(OutputStream stream) {
        Preconditions.checkNotNull((Object)stream, (String)"debug stream can't be null");
        this.debugStream = stream;
        return this;
    }

    public ServiceBuilder debug() {
        this.debugStream((OutputStream)System.out);
        return this;
    }

    public OAuthService build() {
        Preconditions.checkNotNull((Object)this.api, (String)"You must specify a valid api through the provider() method");
        Preconditions.checkEmptyString((String)this.apiKey, (String)"You must provide an api key");
        Preconditions.checkEmptyString((String)this.apiSecret, (String)"You must provide an api secret");
        return this.api.createService(new OAuthConfig(this.apiKey, this.apiSecret, this.callback, this.signatureType, this.scope, this.debugStream));
    }
}

